/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.kernel.impl.util.SequenceArray;

public class ArrayQueueOutOfOrderSequence
implements OutOfOrderSequence {
    private volatile int version;
    private long highestGapFreeNumber;
    private long[] highestGapFreeMeta;
    private final SequenceArray outOfOrderQueue;
    private long[] metaArray;
    private volatile long highestEverSeen;

    public ArrayQueueOutOfOrderSequence(long startingNumber, int initialArraySize, long[] initialMeta) {
        this.highestGapFreeNumber = startingNumber;
        this.highestEverSeen = startingNumber;
        this.metaArray = initialMeta;
        this.highestGapFreeMeta = initialMeta;
        this.outOfOrderQueue = new SequenceArray(initialMeta.length + 1, initialArraySize);
    }

    @Override
    public synchronized boolean offer(long number, long[] meta) {
        this.highestEverSeen = Math.max(this.highestEverSeen, number);
        if (this.highestGapFreeNumber + 1L == number) {
            ++this.version;
            this.highestGapFreeNumber = this.outOfOrderQueue.pollHighestGapFree(number, this.metaArray);
            this.highestGapFreeMeta = this.highestGapFreeNumber == number ? meta : this.metaArray;
            ++this.version;
            return true;
        }
        this.outOfOrderQueue.offer(this.highestGapFreeNumber, number, this.pack(meta));
        return false;
    }

    @Override
    public long highestEverSeen() {
        return this.highestEverSeen;
    }

    private long[] pack(long[] meta) {
        this.metaArray = meta;
        return this.metaArray;
    }

    @Override
    public long[] get() {
        long[] meta;
        long number;
        while (true) {
            int versionBefore;
            if (((versionBefore = this.version) & 1) == 1) {
                continue;
            }
            number = this.highestGapFreeNumber;
            meta = this.highestGapFreeMeta;
            if (this.version == versionBefore) break;
        }
        return this.createResult(number, meta);
    }

    private long[] createResult(long number, long[] meta) {
        long[] result = new long[meta.length + 1];
        result[0] = number;
        System.arraycopy(meta, 0, result, 1, meta.length);
        return result;
    }

    @Override
    public long getHighestGapFreeNumber() {
        return this.highestGapFreeNumber;
    }

    @Override
    public synchronized boolean seen(long number, long[] meta) {
        if (number < this.highestGapFreeNumber) {
            return true;
        }
        if (number == this.highestGapFreeNumber) {
            return this.highestGapFreeMeta == meta;
        }
        return this.outOfOrderQueue.seen(this.highestGapFreeNumber, number, meta);
    }

    @Override
    public synchronized void set(long number, long[] meta) {
        this.highestEverSeen = number;
        this.highestGapFreeNumber = number;
        this.highestGapFreeMeta = meta;
        this.outOfOrderQueue.clear();
    }

    public synchronized String toString() {
        return String.format("out-of-order-sequence:%d %d [%s]", this.highestEverSeen, this.highestGapFreeNumber, this.outOfOrderQueue);
    }
}

