/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;

public class IoThroughputStat
implements Stat {
    private final long startTime;
    private final long endTime;
    private final long position;

    public IoThroughputStat(long startTime, long endTime, long position) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.position = position;
    }

    @Override
    public DetailLevel detailLevel() {
        return DetailLevel.IMPORTANT;
    }

    @Override
    public long asLong() {
        long endTime = this.endTime != 0L ? this.endTime : System.currentTimeMillis();
        long totalTime = endTime - this.startTime;
        int seconds = (int)(totalTime / 1000L);
        return seconds > 0 ? this.position / (long)seconds : -1L;
    }

    public String toString() {
        long stat = this.asLong();
        return stat == -1L ? "??" : Format.bytes(stat) + "/s";
    }
}

