/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;

public class GraphDatabaseBuilder {
    protected DatabaseCreator creator;
    protected Map<String, String> config = new HashMap<String, String>();

    @Deprecated
    public GraphDatabaseBuilder(DatabaseCreator creator) {
        this.creator = creator;
    }

    public GraphDatabaseBuilder setConfig(Setting<?> setting, String value) {
        if (value == null) {
            this.config.remove(setting.name());
        } else {
            Map testValue = MapUtil.stringMap((String[])new String[]{setting.name(), value});
            setting.apply(key -> testValue.containsKey(key) ? (String)testValue.get(key) : this.config.get(key));
            this.config.put(setting.name(), value);
        }
        return this;
    }

    @Deprecated
    public GraphDatabaseBuilder setConfig(String name, String value) {
        if (value == null) {
            this.config.remove(name);
        } else {
            this.config.put(name, value);
        }
        return this;
    }

    @Deprecated
    public GraphDatabaseBuilder setConfig(Map<String, String> config) {
        for (Map.Entry<String, String> stringStringEntry : config.entrySet()) {
            this.setConfig(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        return this;
    }

    public GraphDatabaseBuilder loadPropertiesFromFile(String fileName) throws IllegalArgumentException {
        try {
            return this.loadPropertiesFromURL(new File(fileName).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal filename:" + fileName, e);
        }
    }

    public GraphDatabaseBuilder loadPropertiesFromURL(URL url) throws IllegalArgumentException {
        Properties props = new Properties();
        try {
            InputStream stream = url.openStream();
            Object object = null;
            try {
                props.load(stream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load " + url, e);
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setConfig(key, value);
        }
        return this;
    }

    public GraphDatabaseService newGraphDatabase() {
        return this.creator.newDatabase(Config.defaults(this.config));
    }

    @Deprecated
    public static class Delegator
    extends GraphDatabaseBuilder {
        private final GraphDatabaseBuilder actual;

        public Delegator(GraphDatabaseBuilder actual) {
            super(null);
            this.actual = actual;
        }

        @Override
        public GraphDatabaseBuilder setConfig(Setting<?> setting, String value) {
            this.actual.setConfig(setting, value);
            return this;
        }

        @Override
        public GraphDatabaseBuilder setConfig(String name, String value) {
            this.actual.setConfig(name, value);
            return this;
        }

        @Override
        public GraphDatabaseBuilder setConfig(Map<String, String> config) {
            this.actual.setConfig(config);
            return this;
        }

        @Override
        public GraphDatabaseBuilder loadPropertiesFromFile(String fileName) throws IllegalArgumentException {
            this.actual.loadPropertiesFromFile(fileName);
            return this;
        }

        @Override
        public GraphDatabaseBuilder loadPropertiesFromURL(URL url) throws IllegalArgumentException {
            this.actual.loadPropertiesFromURL(url);
            return this;
        }

        @Override
        public GraphDatabaseService newGraphDatabase() {
            return this.actual.newGraphDatabase();
        }
    }

    @Deprecated
    public static interface DatabaseCreator {
        @Deprecated
        default public GraphDatabaseService newDatabase(Map<String, String> config) {
            return this.newDatabase(Config.defaults(config));
        }

        default public GraphDatabaseService newDatabase(@Nonnull Config config) {
            return this.newDatabase(config.getRaw());
        }
    }
}

