/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;

class PhysicalToLogicalLabelChanges {
    private PhysicalToLogicalLabelChanges() {
    }

    static void convertToAdditionsAndRemovals(NodeLabelUpdate update) {
        int beforeLength = update.getLabelsBefore().length;
        int afterLength = update.getLabelsAfter().length;
        int bc = 0;
        int ac = 0;
        long[] before = update.getLabelsBefore();
        long[] after = update.getLabelsAfter();
        int bi = 0;
        int ai = 0;
        while (bi < beforeLength || ai < afterLength) {
            long afterId;
            long beforeId = bi < beforeLength ? before[bi] : -1L;
            long l = afterId = ai < afterLength ? after[ai] : -1L;
            if (beforeId == afterId) {
                ++bi;
                ++ai;
                continue;
            }
            if (PhysicalToLogicalLabelChanges.smaller(beforeId, afterId)) {
                while (PhysicalToLogicalLabelChanges.smaller(beforeId, afterId) && bi < beforeLength) {
                    update.getLabelsBefore()[bc++] = beforeId;
                    beforeId = ++bi < beforeLength ? before[bi] : -1L;
                }
                continue;
            }
            if (!PhysicalToLogicalLabelChanges.smaller(afterId, beforeId)) continue;
            while (PhysicalToLogicalLabelChanges.smaller(afterId, beforeId) && ai < afterLength) {
                update.getLabelsAfter()[ac++] = afterId;
                afterId = ++ai < afterLength ? after[ai] : -1L;
            }
        }
        PhysicalToLogicalLabelChanges.terminateWithMinusOneIfNeeded(update.getLabelsBefore(), bc);
        PhysicalToLogicalLabelChanges.terminateWithMinusOneIfNeeded(update.getLabelsAfter(), ac);
    }

    private static boolean smaller(long id, long otherId) {
        return id != -1L && (otherId == -1L || id < otherId);
    }

    private static void terminateWithMinusOneIfNeeded(long[] labelIds, int actualLength) {
        if (actualLength < labelIds.length) {
            labelIds[actualLength] = -1L;
        }
    }
}

