/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
extends FusionIndexBase<IndexReader>
implements IndexReader {
    private final IndexDescriptor descriptor;

    FusionIndexReader(SlotSelector slotSelector, LazyInstanceSelector<IndexReader> instanceSelector, IndexDescriptor descriptor) {
        super(slotSelector, instanceSelector);
        this.descriptor = descriptor;
    }

    public void close() {
        this.instanceSelector.close(Resource::close);
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return ((IndexReader)this.instanceSelector.select(this.slotSelector.selectSlot(propertyValues, GROUP_OF))).countIndexedNodes(nodeId, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.instanceSelector.transform(IndexReader::createSampler));
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexSlot slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        return slot != null ? ((IndexReader)this.instanceSelector.select(slot)).query(predicates) : PrimitiveLongResourceCollections.concat(this.instanceSelector.transform(reader -> reader.query(predicates)));
    }

    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexSlot slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        if (slot != null) {
            ((IndexReader)this.instanceSelector.select(slot)).query(cursor, indexOrder, needsValues, predicates);
        } else {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, (IndexProgressor)multiProgressor, predicates, indexOrder, needsValues);
            try {
                this.instanceSelector.forAll(reader -> {
                    try {
                        reader.query((IndexProgressor.NodeValueClient)multiProgressor, indexOrder, needsValues, predicates);
                    }
                    catch (IndexNotApplicableKernelException e) {
                        throw new InnerException(e);
                    }
                });
            }
            catch (InnerException e) {
                throw e.getCause();
            }
        }
    }

    public void distinctValues(IndexProgressor.NodeValueClient cursor, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
        cursor.initialize(this.descriptor, (IndexProgressor)multiProgressor, new IndexQuery[0], IndexOrder.NONE, needsValues);
        this.instanceSelector.forAll(reader -> reader.distinctValues((IndexProgressor.NodeValueClient)multiProgressor, propertyAccessor, needsValues));
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        IndexSlot slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        if (slot != null) {
            return ((IndexReader)this.instanceSelector.select(slot)).hasFullValuePrecision(predicates);
        }
        if (predicates.length != 1 || !(predicates[0] instanceof IndexQuery.ExistsPredicate)) {
            throw new IllegalStateException("Selected IndexReader null for predicates " + Arrays.toString(predicates));
        }
        return true;
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

