/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipState;

class DefaultRelationshipGroupCursor
implements RelationshipGroupCursor {
    private Read read;
    private final DefaultCursors pool;
    private StorageRelationshipGroupCursor storeCursor;
    private boolean hasCheckedTxState;
    private final MutableIntSet txTypes = new IntHashSet();
    private IntIterator txTypeIterator;

    DefaultRelationshipGroupCursor(DefaultCursors pool, StorageRelationshipGroupCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void init(long nodeReference, long reference, Read read) {
        this.storeCursor.init(nodeReference, reference);
        this.txTypes.clear();
        this.txTypeIterator = null;
        this.hasCheckedTxState = false;
        this.read = read;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (!this.hasCheckedTxState) {
            this.checkTxStateForUpdates();
            this.hasCheckedTxState = true;
        }
        if (!this.storeCursor.next()) {
            return this.nextFromTxState();
        }
        this.markTypeAsSeen(this.type());
        return true;
    }

    private boolean nextFromTxState() {
        if (this.txTypeIterator == null && !this.txTypes.isEmpty()) {
            this.txTypeIterator = this.txTypes.intIterator();
        }
        if (this.txTypeIterator != null && this.txTypeIterator.hasNext()) {
            this.storeCursor.setCurrent(this.txTypeIterator.next(), -1, -1, -1);
            return true;
        }
        return false;
    }

    private void markTypeAsSeen(int type) {
        this.txTypes.remove(type);
    }

    private void checkTxStateForUpdates() {
        if (this.read.hasTxStateWithChanges()) {
            NodeState nodeState = this.read.txState().getNodeState(this.storeCursor.getOwningNode());
            LongIterator addedRelationships = nodeState.getAddedRelationships();
            while (addedRelationships.hasNext()) {
                RelationshipState relationshipState = this.read.txState().getRelationshipState(addedRelationships.next());
                relationshipState.accept((relationshipId, typeId, startNodeId, endNodeId) -> this.txTypes.add(typeId));
            }
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this.read = null;
            this.storeCursor.reset();
            if (this.pool != null) {
                this.pool.accept(this);
            }
        }
    }

    public int type() {
        return this.storeCursor.type();
    }

    public int outgoingCount() {
        int count = this.storeCursor.outgoingCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.OUTGOING, count, this.storeCursor.type()) : count;
    }

    public int incomingCount() {
        int count = this.storeCursor.incomingCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.INCOMING, count, this.storeCursor.type()) : count;
    }

    public int loopCount() {
        int count = this.storeCursor.loopCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.LOOP, count, this.storeCursor.type()) : count;
    }

    public void outgoing(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.outgoingReference(), this.read);
    }

    public void incoming(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.incomingReference(), this.read);
    }

    public void loops(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.loopsReference(), this.read);
    }

    public long outgoingReference() {
        long reference = this.storeCursor.outgoingReference();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoOutgoingRels(this.storeCursor.type()) : reference;
    }

    public long incomingReference() {
        long reference = this.storeCursor.incomingReference();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoIncomingRels(this.storeCursor.type()) : reference;
    }

    public long loopsReference() {
        long reference = this.storeCursor.loopsReference();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoLoopRels(this.storeCursor.type()) : reference;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipGroupCursor[closed state]";
        }
        return "RelationshipGroupCursor[id=" + this.storeCursor.groupReference() + ", " + this.storeCursor.toString() + "]";
    }

    public void release() {
        this.storeCursor.close();
    }
}

