/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    private final ThreadToStatementContextBridge txBridge;
    private final PropertyContainerLocker locker;
    public final Transaction.Type transactionType;
    public final SecurityContext securityContext;
    private final ExecutingQuery executingQuery;
    private final Kernel kernel;
    private volatile InternalTransaction transaction;
    private KernelTransaction kernelTransaction;
    private Statement statement;
    private boolean isOpen = true;
    private long pageHits;
    private long pageMisses;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker, InternalTransaction initialTransaction, Statement initialStatement, ExecutingQuery executingQuery, Kernel kernel) {
        this.graph = graph;
        this.txBridge = txBridge;
        this.locker = locker;
        this.transactionType = initialTransaction.transactionType();
        this.securityContext = initialTransaction.securityContext();
        this.executingQuery = executingQuery;
        this.transaction = initialTransaction;
        this.kernelTransaction = txBridge.getKernelTransactionBoundToThisThread(true);
        this.statement = initialStatement;
        this.kernel = kernel;
    }

    @Override
    public ExecutingQuery executingQuery() {
        return this.executingQuery;
    }

    @Override
    public DbmsOperations dbmsOperations() {
        return this.graph.getDbmsOperations();
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.kernelTransaction;
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == Transaction.Type.implicit;
    }

    @Override
    public void close(boolean success) {
        if (this.isOpen) {
            try {
                this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
                this.statement.close();
                if (success) {
                    this.transaction.success();
                } else {
                    this.transaction.failure();
                }
                this.transaction.close();
            }
            finally {
                this.statement = null;
                this.kernelTransaction = null;
                this.transaction = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void terminate() {
        InternalTransaction currentTransaction = this.transaction;
        if (currentTransaction != null) {
            currentTransaction.terminate();
        }
    }

    @Override
    public void commitAndRestartTx() {
        this.checkNotTerminated();
        this.collectTransactionExecutionStatistic();
        QueryRegistryOperations oldQueryRegistryOperations = this.statement.queryRegistration();
        Statement oldStatement = this.statement;
        InternalTransaction oldTransaction = this.transaction;
        KernelTransaction oldKernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.transaction = this.graph.beginTransaction(this.transactionType, (LoginContext)this.securityContext);
        this.kernelTransaction = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.statement = this.kernelTransaction.acquireStatement();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(oldKernelTx);
        oldQueryRegistryOperations.unregisterExecutingQuery(this.executingQuery);
        try {
            oldStatement.close();
            oldTransaction.success();
            oldTransaction.close();
        }
        catch (Throwable t) {
            this.txBridge.bindTransactionToCurrentThread(this.kernelTransaction);
            this.transaction.failure();
            this.transaction.close();
            this.txBridge.unbindTransactionFromCurrentThread();
            throw t;
        }
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(this.kernelTransaction);
    }

    @Override
    public void cleanForReuse() {
        this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
        this.statement.close();
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
    }

    @Override
    public TransactionalContext getOrBeginNewIfClosed() {
        this.checkNotTerminated();
        if (!this.isOpen) {
            this.transaction = this.graph.beginTransaction(this.transactionType, (LoginContext)this.securityContext);
            this.kernelTransaction = this.txBridge.getKernelTransactionBoundToThisThread(true);
            this.statement = this.kernelTransaction.acquireStatement();
            this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
            this.isOpen = true;
        }
        return this;
    }

    private void checkNotTerminated() {
        InternalTransaction currentTransaction = this.transaction;
        if (currentTransaction != null) {
            currentTransaction.terminationReason().ifPresent(status -> {
                throw new TransactionTerminatedException(status);
            });
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public void check() {
        this.kernelTransaction().assertOpen();
    }

    @Override
    public TxStateHolder stateView() {
        return (KernelTransactionImplementation)this.kernelTransaction();
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer p) {
        return this.locker.exclusiveLock(this.kernelTransaction(), p);
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
        return this.transaction.overrideWith(context);
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public ResourceTracker resourceTracker() {
        return this.statement;
    }

    @Override
    public StatisticProvider kernelStatisticProvider() {
        return new TransactionalContextStatisticProvider(this.kernelTransaction().executionStatistics());
    }

    private void collectTransactionExecutionStatistic() {
        ExecutionStatistics stats = this.kernelTransaction().executionStatistics();
        this.pageHits += stats.pageHits();
        this.pageMisses += stats.pageFaults();
    }

    public Neo4jTransactionalContext copyFrom(GraphDatabaseQueryService graph, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker, InternalTransaction initialTransaction, Statement initialStatement, ExecutingQuery executingQuery) {
        return new Neo4jTransactionalContext(graph, txBridge, locker, initialTransaction, initialStatement, executingQuery, this.kernel);
    }

    private class TransactionalContextStatisticProvider
    implements StatisticProvider {
        private final ExecutionStatistics executionStatistics;

        private TransactionalContextStatisticProvider(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
        }

        @Override
        public long getPageCacheHits() {
            return this.executionStatistics.pageHits() + Neo4jTransactionalContext.this.pageHits;
        }

        @Override
        public long getPageCacheMisses() {
            return this.executionStatistics.pageFaults() + Neo4jTransactionalContext.this.pageMisses;
        }
    }

    static interface Creator {
        public Neo4jTransactionalContext create(InternalTransaction var1, Statement var2, ExecutingQuery var3);
    }
}

