/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.InconsistentDataReadException;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.PropertyValueRecordSizeCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.TemporalValueWriterAdapter;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.UnsupportedFormatCapabilityException;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class PropertyStore
extends CommonAbstractStore<PropertyRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    private final DynamicStringStore stringStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final DynamicArrayStore arrayStore;
    private final boolean allowStorePointsAndTemporal;

    public PropertyStore(File file, File idFile, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(file, idFile, configuration, IdType.PROPERTY, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.property(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
        this.stringStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayStore = arrayPropertyStore;
        this.allowStorePointsAndTemporal = recordFormats.hasCapability(Capability.POINT_PROPERTIES) && recordFormats.hasCapability(Capability.TEMPORAL_PROPERTIES);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyRecord record) throws FAILURE {
        processor.processProperty(this, record);
    }

    public DynamicStringStore getStringStore() {
        return this.stringStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayStore;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    @Override
    public void updateRecord(PropertyRecord record) {
        this.updatePropertyBlocks(record);
        super.updateRecord(record);
    }

    private void updatePropertyBlocks(PropertyRecord record) {
        if (record.inUse()) {
            for (PropertyBlock block : record) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords());
            }
        }
        this.updateDynamicRecords(record.getDeletedRecords());
    }

    private void updateDynamicRecords(List<DynamicRecord> records) {
        for (DynamicRecord valueRecord : records) {
            PropertyType recordType = valueRecord.getType();
            if (recordType == PropertyType.STRING) {
                this.stringStore.updateRecord(valueRecord);
                continue;
            }
            if (recordType == PropertyType.ARRAY) {
                this.arrayStore.updateRecord(valueRecord);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    @Override
    public void ensureHeavy(PropertyRecord record) {
        for (PropertyBlock block : record) {
            this.ensureHeavy(block);
        }
    }

    @Override
    public void ensureHeavy(PropertyBlock block) {
        if (!block.isLight()) {
            return;
        }
        PropertyType type = block.getType();
        RecordStore<DynamicRecord> dynamicStore = this.dynamicStoreForValueType(type);
        if (dynamicStore != null) {
            List<DynamicRecord> dynamicRecords = dynamicStore.getRecords(block.getSingleValueLong(), RecordLoad.NORMAL);
            for (DynamicRecord dynamicRecord : dynamicRecords) {
                dynamicRecord.setType(type.intValue());
            }
            block.setValueRecords(dynamicRecords);
        }
    }

    private RecordStore<DynamicRecord> dynamicStoreForValueType(PropertyType type) {
        switch (type) {
            case ARRAY: {
                return this.arrayStore;
            }
            case STRING: {
                return this.stringStore;
            }
        }
        return null;
    }

    public Value getValue(PropertyBlock propertyBlock) {
        return propertyBlock.getType().value(propertyBlock, this);
    }

    private static void allocateStringRecords(Collection<DynamicRecord> target, byte[] chars, DynamicRecordAllocator allocator) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, chars, allocator);
    }

    private static void allocateArrayRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator allocator, boolean allowStorePoints) {
        DynamicArrayStore.allocateRecords(target, array, allocator, allowStorePoints);
    }

    public void encodeValue(PropertyBlock block, int keyId, Value value) {
        PropertyStore.encodeValue(block, keyId, value, this.stringStore, this.arrayStore, this.allowStorePointsAndTemporal);
    }

    public static void encodeValue(PropertyBlock block, int keyId, Value value, DynamicRecordAllocator stringAllocator, DynamicRecordAllocator arrayAllocator, boolean allowStorePointsAndTemporal) {
        if (value instanceof ArrayValue) {
            Object asObject = value.asObject();
            if (ShortArray.encode(keyId, asObject, block, PropertyType.getPayloadSize())) {
                return;
            }
            ArrayList<DynamicRecord> arrayRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateArrayRecords(arrayRecords, asObject, arrayAllocator, allowStorePointsAndTemporal);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.ARRAY, ((DynamicRecord)Iterables.first(arrayRecords)).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
            }
            block.setValueRecords(arrayRecords);
        } else {
            value.writeTo((ValueWriter)new PropertyBlockValueWriter(block, keyId, stringAllocator, allowStorePointsAndTemporal));
        }
    }

    public PageCursor openStringPageCursor(long reference) {
        return this.stringStore.openPageCursorForReading(reference);
    }

    public PageCursor openArrayPageCursor(long reference) {
        return this.arrayStore.openPageCursorForReading(reference);
    }

    public ByteBuffer loadString(long reference, ByteBuffer buffer, PageCursor page) {
        return PropertyStore.readDynamic(this.stringStore, reference, buffer, page);
    }

    public ByteBuffer loadArray(long reference, ByteBuffer buffer, PageCursor page) {
        return PropertyStore.readDynamic(this.arrayStore, reference, buffer, page);
    }

    private static ByteBuffer readDynamic(AbstractDynamicStore store, long reference, ByteBuffer buffer, PageCursor page) {
        if (buffer == null) {
            buffer = ByteBuffer.allocate(512);
        } else {
            buffer.clear();
        }
        DynamicRecord record = (DynamicRecord)store.newRecord();
        MutableLongSet seenDynamicIds = null;
        long firstReference = reference;
        int count = 0;
        do {
            store.getRecordByCursor(reference, record, RecordLoad.FORCE, page);
            reference = record.getNextBlock();
            byte[] data = record.getData();
            if (buffer.remaining() < data.length) {
                buffer = PropertyStore.grow(buffer, data.length);
            }
            buffer.put(data, 0, data.length);
            if (++count < 100000) continue;
            if (seenDynamicIds == null) {
                seenDynamicIds = LongSets.mutable.empty();
            }
            if (seenDynamicIds.add(reference)) continue;
            throw new InconsistentDataReadException("Chain cycle detected in dynamic property value store %s starting at id:%d", store, firstReference);
        } while (reference != -1L);
        return buffer;
    }

    private static ByteBuffer grow(ByteBuffer buffer, int required) {
        buffer.flip();
        int capacity = buffer.capacity();
        while ((capacity *= 2) - buffer.limit() < required) {
        }
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN).put(buffer);
    }

    public static void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock(PropertyStore.singleBlockLongValue(keyId, type, longValue));
    }

    public static long singleBlockLongValue(int keyId, PropertyType type, long longValue) {
        return (long)keyId | (long)type.intValue() << 24 | longValue << 28;
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode((String)string);
    }

    public static String decodeString(byte[] byteArray) {
        return UTF8.decode((byte[])byteArray);
    }

    String getStringFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getStringFor(propertyBlock.getValueRecords());
    }

    private String getStringFor(Collection<DynamicRecord> dynamicRecords) {
        Pair<byte[], byte[]> source = this.stringStore.readFullByteArray(dynamicRecords, PropertyType.STRING);
        return PropertyStore.decodeString((byte[])source.other());
    }

    Value getArrayFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getArrayFor(propertyBlock.getValueRecords());
    }

    private Value getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.arrayStore.readFullByteArray(records, PropertyType.ARRAY));
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId) {
        long nextProp = firstRecordId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = new PropertyRecord(nextProp);
            this.getRecord(nextProp, propRecord, RecordLoad.NORMAL);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    @Override
    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public boolean allowStorePointsAndTemporal() {
        return this.allowStorePointsAndTemporal;
    }

    public ToIntFunction<Value[]> newValueEncodedSizeCalculator() {
        return new PropertyValueRecordSizeCalculator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayValue readArrayFromBuffer(ByteBuffer buffer) {
        if (buffer.limit() <= 0) {
            throw new IllegalStateException("Given buffer is empty");
        }
        byte typeId = buffer.get();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            if (typeId == PropertyType.STRING.intValue()) {
                int arrayLength = buffer.getInt();
                String[] result = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    int byteLength = buffer.getInt();
                    result[i] = UTF8.decode((byte[])buffer.array(), (int)buffer.position(), (int)byteLength);
                    buffer.position(buffer.position() + byteLength);
                }
                TextArray i = Values.stringArray((String[])result);
                return i;
            }
            if (typeId == PropertyType.GEOMETRY.intValue()) {
                GeometryType.GeometryHeader header = GeometryType.GeometryHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = GeometryType.decodeGeometryArray(header, byteArray);
                return i;
            }
            if (typeId == PropertyType.TEMPORAL.intValue()) {
                TemporalType.TemporalHeader header = TemporalType.TemporalHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = TemporalType.decodeTemporalArray(header, byteArray);
                return i;
            }
            ShortArray type = ShortArray.typeOf(typeId);
            byte bitsUsedInLastByte = buffer.get();
            byte requiredBits = buffer.get();
            if (requiredBits == 0) {
                ArrayValue byteLength = type.createEmptyArray();
                return byteLength;
            }
            if (type == ShortArray.BYTE && requiredBits == 8) {
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ByteArray byteArray2 = Values.byteArray((byte[])byteArray);
                return byteArray2;
            }
            Bits bits = Bits.bitsFromBytes(buffer.array(), buffer.position());
            int length = ((buffer.limit() - buffer.position()) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
            ArrayValue arrayValue = type.createArray(length, bits, requiredBits);
            return arrayValue;
        }
        finally {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private static class PropertyBlockValueWriter
    extends TemporalValueWriterAdapter<IllegalArgumentException> {
        private final PropertyBlock block;
        private final int keyId;
        private final DynamicRecordAllocator stringAllocator;
        private final boolean allowStorePointsAndTemporal;

        PropertyBlockValueWriter(PropertyBlock block, int keyId, DynamicRecordAllocator stringAllocator, boolean allowStorePointsAndTemporal) {
            this.block = block;
            this.keyId = keyId;
            this.stringAllocator = stringAllocator;
            this.allowStorePointsAndTemporal = allowStorePointsAndTemporal;
        }

        public void writeNull() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot write null values to the property store");
        }

        public void writeBoolean(boolean value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BOOL, value ? 1L : 0L);
        }

        public void writeInteger(byte value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BYTE, value);
        }

        public void writeInteger(short value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.SHORT, value);
        }

        public void writeInteger(int value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.INT, value);
        }

        public void writeInteger(long value) throws IllegalArgumentException {
            long keyAndType = (long)this.keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits(value) <= 35) {
                this.block.setSingleBlock(keyAndType | 0x10000000L | value << 29);
            } else {
                this.block.setValueBlocks(new long[]{keyAndType, value});
            }
        }

        public void writeFloatingPoint(float value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.FLOAT, Float.floatToRawIntBits(value));
        }

        public void writeFloatingPoint(double value) throws IllegalArgumentException {
            this.block.setValueBlocks(new long[]{(long)this.keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits(value)});
        }

        public void writeString(String value) throws IllegalArgumentException {
            if (LongerShortString.encode(this.keyId, value, this.block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(value);
            ArrayList<DynamicRecord> valueRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateStringRecords(valueRecords, encodedString, this.stringAllocator);
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.STRING, ((DynamicRecord)Iterables.first(valueRecords)).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
            }
            this.block.setValueRecords(valueRecords);
        }

        public void writeString(char value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.CHAR, value);
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void endArray() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writeByteArray(byte[] value) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.POINT_PROPERTIES);
            }
            this.block.setValueBlocks(GeometryType.encodePoint(this.keyId, crs, coordinate));
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDuration(this.keyId, months, days, seconds, nanos));
        }

        @Override
        public void writeDate(long epochDay) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDate(this.keyId, epochDay));
        }

        @Override
        public void writeLocalTime(long nanoOfDay) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeLocalTime(this.keyId, nanoOfDay));
        }

        @Override
        public void writeTime(long nanosOfDayUTC, int offsetSeconds) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeTime(this.keyId, nanosOfDayUTC, offsetSeconds));
        }

        @Override
        public void writeLocalDateTime(long epochSecond, int nano) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeLocalDateTime(this.keyId, epochSecond, nano));
        }

        @Override
        public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, offsetSeconds));
        }

        @Override
        public void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(Capability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, zoneId));
        }
    }
}

