/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.NoSuchElementException;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;

public abstract class BatchImporterFactory
extends Service {
    private final int priority;

    protected BatchImporterFactory(String key, int priority) {
        super(key, new String[0]);
        this.priority = priority;
    }

    public abstract BatchImporter instantiate(DatabaseLayout var1, FileSystemAbstraction var2, PageCache var3, Configuration var4, LogService var5, ExecutionMonitor var6, AdditionalInitialIds var7, Config var8, RecordFormats var9, ImportLogic.Monitor var10, JobScheduler var11);

    public static BatchImporterFactory withHighestPriority() {
        Iterable<BatchImporterFactory> candidates = Service.load(BatchImporterFactory.class);
        BatchImporterFactory highestPrioritized = null;
        for (BatchImporterFactory candidate : candidates) {
            if (highestPrioritized != null && candidate.priority <= highestPrioritized.priority) continue;
            highestPrioritized = candidate;
        }
        if (highestPrioritized == null) {
            throw new NoSuchElementException("No batch importers found");
        }
        return highestPrioritized;
    }
}

