/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.helpers.collection.Iterators;

public class Workers<R extends Runnable>
implements Iterable<R> {
    private final List<Worker> workers = new ArrayList<Worker>();
    private final String names;

    public Workers(String names) {
        this.names = names;
    }

    public void start(R toRun) {
        Worker worker = new Worker(this, this.names + "-" + this.workers.size(), toRun);
        worker.start();
        this.workers.add(worker);
    }

    public Throwable await() throws InterruptedException {
        Throwable error = null;
        for (Worker worker : this.workers) {
            Throwable anError = worker.await();
            if (error != null) continue;
            error = anError;
        }
        return error;
    }

    public void awaitAndThrowOnError() throws InterruptedException {
        Throwable error = this.await();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    public void awaitAndThrowOnErrorStrict() {
        try {
            this.awaitAndThrowOnError();
        }
        catch (InterruptedException e) {
            throw this.handleInterrupted(e);
        }
    }

    private RuntimeException handleInterrupted(InterruptedException e) {
        Thread.interrupted();
        return new RuntimeException("Got interrupted while awaiting workers (" + this.names + ") to complete", e);
    }

    @Override
    public Iterator<R> iterator() {
        return Iterators.map(worker -> ((Worker)worker).toRun, this.workers.iterator());
    }

    private static class Worker
    extends Thread {
        private volatile Throwable error;
        private final R toRun;
        final /* synthetic */ Workers this$0;

        Worker(String name, R toRun) {
            this.this$0 = var1_1;
            super(name);
            this.toRun = toRun;
        }

        @Override
        public void run() {
            try {
                this.toRun.run();
            }
            catch (Throwable t) {
                this.error = t;
                throw new RuntimeException(t);
            }
        }

        protected synchronized Throwable await() throws InterruptedException {
            this.join();
            return this.error;
        }
    }
}

