/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputEntity
implements InputEntityVisitor,
Cloneable {
    public static final Object[] NO_PROPERTIES = new Object[0];
    public static final String[] NO_LABELS = new String[0];
    private final InputEntityVisitor delegate;
    public boolean hasPropertyId;
    public long propertyId;
    public boolean hasIntPropertyKeyIds;
    public final List<Object> properties = new ArrayList<Object>();
    public boolean hasLongId;
    public long longId;
    public Object objectId;
    public Group idGroup;
    public final List<String> labels = new ArrayList<String>();
    public boolean hasLabelField;
    public long labelField;
    public boolean hasLongStartId;
    public long longStartId;
    public Object objectStartId;
    public Group startIdGroup;
    public boolean hasLongEndId;
    public long longEndId;
    public Object objectEndId;
    public Group endIdGroup;
    public boolean hasIntType;
    public int intType;
    public String stringType;
    private boolean end;

    public InputEntity(InputEntityVisitor delegate) {
        this.delegate = delegate;
        this.clear();
    }

    public InputEntity() {
        this(InputEntityVisitor.NULL);
    }

    @Override
    public boolean propertyId(long nextProp) {
        this.checkClear();
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return this.delegate.propertyId(nextProp);
    }

    @Override
    public boolean property(String key, Object value) {
        this.checkClear();
        this.properties.add(key);
        this.properties.add(value);
        return this.delegate.property(key, value);
    }

    @Override
    public boolean property(int propertyKeyId, Object value) {
        this.checkClear();
        this.hasIntPropertyKeyIds = true;
        this.properties.add(propertyKeyId);
        this.properties.add(value);
        return this.delegate.property(propertyKeyId, value);
    }

    @Override
    public boolean id(long id) {
        this.checkClear();
        this.hasLongId = true;
        this.longId = id;
        return this.delegate.id(id);
    }

    @Override
    public boolean id(Object id, Group group) {
        this.checkClear();
        this.objectId = id;
        this.idGroup = group;
        return this.delegate.id(id, group);
    }

    @Override
    public boolean labels(String[] labels) {
        this.checkClear();
        Collections.addAll(this.labels, labels);
        return this.delegate.labels(labels);
    }

    @Override
    public boolean labelField(long labelField) {
        this.checkClear();
        this.hasLabelField = true;
        this.labelField = labelField;
        return this.delegate.labelField(labelField);
    }

    @Override
    public boolean startId(long id) {
        this.checkClear();
        this.hasLongStartId = true;
        this.longStartId = id;
        return this.delegate.startId(id);
    }

    @Override
    public boolean startId(Object id, Group group) {
        this.checkClear();
        this.objectStartId = id;
        this.startIdGroup = group;
        return this.delegate.startId(id, group);
    }

    @Override
    public boolean endId(long id) {
        this.checkClear();
        this.hasLongEndId = true;
        this.longEndId = id;
        return this.delegate.endId(id);
    }

    @Override
    public boolean endId(Object id, Group group) {
        this.checkClear();
        this.objectEndId = id;
        this.endIdGroup = group;
        return this.delegate.endId(id, group);
    }

    @Override
    public boolean type(int type) {
        this.checkClear();
        this.hasIntType = true;
        this.intType = type;
        return this.delegate.type(type);
    }

    @Override
    public boolean type(String type) {
        this.checkClear();
        this.stringType = type;
        return this.delegate.type(type);
    }

    @Override
    public void endOfEntity() throws IOException {
        this.end = true;
        this.delegate.endOfEntity();
    }

    public String[] labels() {
        return this.labels.toArray(new String[this.labels.size()]);
    }

    public Object[] properties() {
        return this.properties.toArray();
    }

    public Object id() {
        return this.hasLongId ? Long.valueOf(this.longId) : this.objectId;
    }

    public Object endId() {
        return this.hasLongEndId ? Long.valueOf(this.longEndId) : this.objectEndId;
    }

    public Object startId() {
        return this.hasLongStartId ? Long.valueOf(this.longStartId) : this.objectStartId;
    }

    private void checkClear() {
        if (this.end) {
            this.clear();
        }
    }

    private void clear() {
        this.end = false;
        this.hasPropertyId = false;
        this.propertyId = -1L;
        this.hasIntPropertyKeyIds = false;
        this.properties.clear();
        this.hasLongId = false;
        this.longId = -1L;
        this.objectId = null;
        this.idGroup = Group.GLOBAL;
        this.labels.clear();
        this.hasLabelField = false;
        this.labelField = -1L;
        this.hasLongStartId = false;
        this.longStartId = -1L;
        this.objectStartId = null;
        this.startIdGroup = Group.GLOBAL;
        this.hasLongEndId = false;
        this.longEndId = -1L;
        this.objectEndId = null;
        this.endIdGroup = Group.GLOBAL;
        this.hasIntType = false;
        this.intType = -1;
        this.stringType = null;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public int propertyCount() {
        return this.properties.size() / 2;
    }

    public Object propertyKey(int i) {
        return this.properties.get(i * 2);
    }

    public Object propertyValue(int i) {
        return this.properties.get(i * 2 + 1);
    }

    public void replayOnto(InputEntityVisitor visitor) throws IOException {
        if (this.hasPropertyId) {
            visitor.propertyId(this.propertyId);
        } else if (!this.properties.isEmpty()) {
            int propertyCount = this.propertyCount();
            for (int i = 0; i < propertyCount; ++i) {
                if (this.hasIntPropertyKeyIds) {
                    visitor.property((Integer)this.propertyKey(i), this.propertyValue(i));
                    continue;
                }
                visitor.property((String)this.propertyKey(i), this.propertyValue(i));
            }
        }
        if (this.hasLongId) {
            visitor.id(this.longId);
        } else if (this.objectId != null) {
            visitor.id(this.objectId, this.idGroup);
        }
        if (this.hasLabelField) {
            visitor.labelField(this.labelField);
        } else if (!this.labels.isEmpty()) {
            visitor.labels(this.labels.toArray(new String[this.labels.size()]));
        }
        if (this.hasLongStartId) {
            visitor.startId(this.longStartId);
        } else if (this.objectStartId != null) {
            visitor.startId(this.objectStartId, this.startIdGroup);
        }
        if (this.hasLongEndId) {
            visitor.endId(this.longEndId);
        } else if (this.objectEndId != null) {
            visitor.endId(this.objectEndId, this.endIdGroup);
        }
        if (this.hasIntType) {
            visitor.type(this.intType);
        } else if (this.stringType != null) {
            visitor.type(this.stringType);
        }
        visitor.endOfEntity();
    }
}

