/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInputChunk;

public class CsvInputChunkProxy
implements CsvInputChunk {
    private CsvInputChunk actual;
    private int groupId = -1;

    public void ensureInstantiated(Supplier<CsvInputChunk> newChunk, int groupId) throws IOException {
        if (this.actual == null || groupId != this.groupId) {
            this.closeCurrent();
            this.actual = newChunk.get();
        }
        this.groupId = groupId;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.actual != null) {
            this.actual.close();
        }
    }

    @Override
    public boolean fillFrom(Chunker chunker) throws IOException {
        return this.actual.fillFrom(chunker);
    }

    @Override
    public boolean next(InputEntityVisitor visitor) throws IOException {
        return this.actual.next(visitor);
    }
}

