/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.time.Clock;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.time.Clocks;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class MultiExecutionMonitor
implements ExecutionMonitor {
    private final Clock clock;
    private final ExecutionMonitor[] monitors;
    private final long[] endTimes;

    public MultiExecutionMonitor(ExecutionMonitor ... monitors) {
        this(Clocks.systemClock(), monitors);
    }

    public MultiExecutionMonitor(Clock clock, ExecutionMonitor ... monitors) {
        this.clock = clock;
        this.monitors = monitors;
        this.endTimes = new long[monitors.length];
        this.fillEndTimes();
    }

    @Override
    public void initialize(DependencyResolver dependencyResolver) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.initialize(dependencyResolver);
        }
    }

    @Override
    public void start(StageExecution execution) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.start(execution);
        }
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.end(execution, totalTimeMillis);
        }
    }

    @Override
    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.done(successful, totalTimeMillis, additionalInformation);
        }
    }

    @Override
    public long nextCheckTime() {
        long low = this.endTimes[0];
        for (int i = 1; i < this.monitors.length; ++i) {
            long thisLow = this.endTimes[i];
            if (thisLow >= low) continue;
            low = thisLow;
        }
        return low;
    }

    private void fillEndTimes() {
        for (int i = 0; i < this.monitors.length; ++i) {
            this.endTimes[i] = this.monitors[i].nextCheckTime();
        }
    }

    @Override
    public void check(StageExecution execution) {
        long currentTimeMillis = this.clock.millis();
        for (int i = 0; i < this.monitors.length; ++i) {
            if (currentTimeMillis < this.endTimes[i]) continue;
            this.monitors[i].check(execution);
            this.endTimes[i] = this.monitors[i].nextCheckTime();
        }
    }
}

