/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Collections;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public class DatabaseRepository<DB extends DatabaseContext>
implements DatabaseContextProvider<DB> {
    private final DatabaseIdRepository databaseIdRepository;
    private final ConcurrentHashMap<NamedDatabaseId, DB> databaseMap = new ConcurrentHashMap();

    public DatabaseRepository(DatabaseIdRepository databaseIdRepository) {
        this.databaseIdRepository = databaseIdRepository;
    }

    public void add(NamedDatabaseId namedDatabaseId, DB databaseContext) {
        this.databaseMap.put(namedDatabaseId, databaseContext);
    }

    public void remove(NamedDatabaseId namedDatabaseId) {
        this.databaseMap.remove(namedDatabaseId);
    }

    @Override
    public Optional<DB> getDatabaseContext(NamedDatabaseId namedDatabaseId) {
        return Optional.ofNullable((DatabaseContext)this.databaseMap.get(namedDatabaseId));
    }

    @Override
    public Optional<DB> getDatabaseContext(String databaseName) {
        return this.databaseIdRepository.getByName(databaseName).flatMap(this::getDatabaseContext);
    }

    @Override
    public Optional<DB> getDatabaseContext(DatabaseId databaseId) {
        return this.databaseIdRepository.getById(databaseId).flatMap(this::getDatabaseContext);
    }

    @Override
    public NavigableMap<NamedDatabaseId, DB> registeredDatabases() {
        return Collections.unmodifiableNavigableMap(new TreeMap<NamedDatabaseId, DB>(this.databaseMap));
    }

    @Override
    public DatabaseIdRepository databaseIdRepository() {
        return this.databaseIdRepository;
    }
}

