/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public abstract class KnownSystemComponentVersion {
    public static final int UNKNOWN_VERSION = -1;
    private final ComponentVersion componentVersion;
    protected final SystemGraphComponent.Name componentName;
    public final int version;
    public final String description;
    protected final Log debugLog;

    protected KnownSystemComponentVersion(ComponentVersion componentVersion, Log debugLog) {
        this.componentVersion = componentVersion;
        this.componentName = componentVersion.getComponentName();
        this.version = componentVersion.getVersion();
        this.description = componentVersion.getDescription();
        this.debugLog = debugLog;
    }

    public boolean isCurrent(Config config) {
        return this.componentVersion.isCurrent(config);
    }

    public boolean migrationSupported() {
        return this.componentVersion.migrationSupported();
    }

    public boolean runtimeSupported() {
        return this.componentVersion.runtimeSupported();
    }

    protected Integer getSystemGraphInstalledVersion(Transaction tx) {
        return SystemGraphComponent.getVersionNumber(tx, this.componentName);
    }

    public int binaryVersion() {
        return this.version;
    }

    public boolean detected(Transaction tx) {
        Integer version = this.getSystemGraphInstalledVersion(tx);
        return version != null && version == this.version;
    }

    public UnsupportedOperationException unsupported() {
        String message = String.format("System graph version %d for component '%s' in '%s' is not supported", this.version, this.componentName, this.description);
        this.debugLog.error(message);
        return new UnsupportedOperationException(message);
    }

    public SystemGraphComponent.Status getStatus(Config config) {
        if (this.version == -1) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (this.isCurrent(config)) {
            return SystemGraphComponent.Status.CURRENT;
        }
        if (this.migrationSupported()) {
            return this.runtimeSupported() ? SystemGraphComponent.Status.REQUIRES_UPGRADE : SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE;
        }
        return SystemGraphComponent.Status.UNSUPPORTED;
    }

    protected static boolean nodesWithLabelExist(Transaction tx, Label label) {
        try (ResourceIterator nodes = tx.findNodes(label);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    public void setVersionProperty(Transaction tx, int newVersion) {
        KnownSystemComponentVersion.setVersionProperty(tx, newVersion, this.componentName, this.debugLog);
    }

    public static void setVersionProperty(Transaction tx, int newVersion, SystemGraphComponent.Name componentName, Log debugLog) {
        Node versionNode = KnownSystemComponentVersion.findOrCreateVersionNode(tx);
        Object oldVersion = versionNode.getProperty(componentName.name(), null);
        if (oldVersion != null) {
            debugLog.info(String.format("Upgrading '%s' version property from %s to %d", componentName, oldVersion, newVersion));
        } else {
            debugLog.info(String.format("Setting version for '%s' to %d", componentName, newVersion));
        }
        versionNode.setProperty(componentName.name(), (Object)newVersion);
    }

    private static Node findOrCreateVersionNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(SystemGraphComponent.VERSION_LABEL);){
            if (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                if (nodes.hasNext()) {
                    throw new IllegalStateException("More than one Version node exists");
                }
                Node node2 = node;
                return node2;
            }
        }
        return tx.createNode(new Label[]{SystemGraphComponent.VERSION_LABEL});
    }
}

