/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.util.VisibleForTesting;

public class StandaloneDbmsRuntimeVersionProvider
implements TransactionEventListener<Object>,
DbmsRuntimeVersionProvider {
    protected final DbmsRuntimeSystemGraphComponent component;
    private final DatabaseContextProvider<?> databaseContextProvider;
    private volatile DbmsRuntimeVersion currentVersion;

    public StandaloneDbmsRuntimeVersionProvider(DatabaseContextProvider<?> databaseContextProvider, DbmsRuntimeSystemGraphComponent component) {
        this.databaseContextProvider = databaseContextProvider;
        this.component = component;
    }

    public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
        return null;
    }

    public void afterCommit(TransactionData transactionData, Object state, GraphDatabaseService databaseService) {
        if (transactionData == null || this.getVersion().isCurrent(this.component.config)) {
            return;
        }
        List<Long> nodesWithChangedProperties = Iterables.stream((Iterable)transactionData.assignedNodeProperties()).map(nodePropertyEntry -> ((Node)nodePropertyEntry.entity()).getId()).toList();
        GraphDatabaseService systemDatabase = this.getSystemDb();
        try (Transaction tx = systemDatabase.beginTx();){
            nodesWithChangedProperties.stream().map(arg_0 -> ((Transaction)tx).getNodeById(arg_0)).filter(node -> node.hasLabel(SystemGraphComponent.VERSION_LABEL) && node.hasProperty(this.component.componentName().name())).map(dbmRuntime -> (int)((Integer)dbmRuntime.getProperty(this.component.componentName().name()))).map(DbmsRuntimeVersion::fromVersionNumber).forEach(this::setVersion);
        }
    }

    public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
    }

    private void fetchStateFromSystemDatabase() {
        GraphDatabaseService systemDatabase = this.getSystemDb();
        this.currentVersion = (DbmsRuntimeVersion)this.component.fetchStateFromSystemDatabase(systemDatabase);
    }

    private GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("Failed to get System Database"))).databaseFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbmsRuntimeVersion getVersion() {
        if (this.currentVersion == null) {
            StandaloneDbmsRuntimeVersionProvider standaloneDbmsRuntimeVersionProvider = this;
            synchronized (standaloneDbmsRuntimeVersionProvider) {
                if (this.currentVersion == null) {
                    this.fetchStateFromSystemDatabase();
                }
            }
        }
        return this.currentVersion;
    }

    @VisibleForTesting
    void setVersion(DbmsRuntimeVersion newVersion) {
        this.currentVersion = newVersion;
    }
}

