/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint.volume;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.checkpoint.volume.VolumeCheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.time.SystemNanoClock;

public class VolumeThresholdPolicy
implements CheckPointThresholdPolicy {
    public String getName() {
        return "volume";
    }

    @Override
    public CheckPointThreshold createThreshold(Config config, SystemNanoClock clock, LogPruning logPruning, InternalLogProvider logProvider) {
        long checkpointIntervalVolume = (Long)config.get(GraphDatabaseSettings.check_point_interval_volume);
        long logFileSize = (Long)config.get(GraphDatabaseSettings.logical_log_rotation_threshold);
        return new VolumeCheckPointThreshold(checkpointIntervalVolume, logFileSize);
    }
}

