/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.index.schema.TokenIndexIdLayout;
import org.neo4j.kernel.impl.index.schema.TokenScan;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexProgressor;
import org.neo4j.util.Preconditions;

public class DefaultTokenIndexReader
implements TokenIndexReader {
    private final GBPTree<TokenScanKey, TokenScanValue> index;
    private final IndexUsageTracker usageTracker;
    private final TokenIndexIdLayout idLayout;

    public DefaultTokenIndexReader(GBPTree<TokenScanKey, TokenScanValue> index, IndexUsageTracker usageTracker, TokenIndexIdLayout idLayout) {
        this.index = index;
        this.usageTracker = usageTracker;
        this.idLayout = idLayout;
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) {
        this.usageTracker.queried();
        this.query(client, constraints, query, EntityRange.FULL, cursorContext);
    }

    public void query(IndexProgressor.EntityTokenClient client, IndexQueryConstraints constraints, TokenPredicate query, EntityRange range, CursorContext cursorContext) {
        try {
            int tokenId = query.tokenId();
            IndexOrder order = constraints.order();
            Seeker<TokenScanKey, TokenScanValue> seeker = this.seekerForToken(range, tokenId, order, cursorContext);
            TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(seeker, client, order, range, this.idLayout, tokenId);
            client.initialize((IndexProgressor)progressor, tokenId, order);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TokenScan entityTokenScan(int tokenId, CursorContext cursorContext) {
        try {
            this.usageTracker.queried();
            long highestEntityIdForToken = this.highestEntityIdForToken(tokenId, cursorContext);
            return new NativeTokenScan(tokenId, highestEntityIdForToken);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PartitionedTokenScan entityTokenScan(int desiredNumberOfPartitions, CursorContext context, TokenPredicate query) {
        try {
            this.usageTracker.queried();
            return new NativePartitionedTokenScan(desiredNumberOfPartitions, context, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PartitionedTokenScan entityTokenScan(PartitionedTokenScan leadingPartition, TokenPredicate query) {
        this.usageTracker.queried();
        return new NativePartitionedTokenScan((NativePartitionedTokenScan)leadingPartition, query);
    }

    private long highestEntityIdForToken(int tokenId, CursorContext cursorContext) throws IOException {
        try (Seeker seeker = this.index.seek((Object)new TokenScanKey(tokenId, Long.MAX_VALUE), (Object)new TokenScanKey(tokenId, Long.MIN_VALUE), cursorContext);){
            long l = seeker.next() ? this.idLayout.firstIdOfRange(((TokenScanKey)seeker.key()).idRange + 1L) : 0L;
            return l;
        }
    }

    private Seeker<TokenScanKey, TokenScanValue> seekerForToken(EntityRange range, int tokenId, IndexOrder indexOrder, CursorContext cursorContext) throws IOException {
        long idRangeToExclusive;
        long idRangeFromInclusive;
        if (indexOrder == IndexOrder.DESCENDING) {
            idRangeFromInclusive = this.idLayout.rangeOf(range.toExclusive());
            idRangeToExclusive = this.idLayout.rangeOf(range.fromInclusive()) - 1L;
        } else {
            idRangeFromInclusive = this.idLayout.rangeOf(range.fromInclusive());
            idRangeToExclusive = this.idLayout.rangeOf(range.toExclusive()) + 1L;
        }
        return this.index.seek((Object)new TokenScanKey(tokenId, idRangeFromInclusive), (Object)new TokenScanKey(tokenId, idRangeToExclusive), cursorContext);
    }

    public void printTree(PrintConfig printConfig) throws IOException {
        this.index.printTree(printConfig, CursorContext.NULL_CONTEXT);
    }

    public void close() {
        this.usageTracker.close();
    }

    private class NativeTokenScan
    implements TokenScan {
        private final AtomicLong nextStart;
        private final int tokenId;
        private final long max;

        NativeTokenScan(int tokenId, long max) {
            this.tokenId = tokenId;
            this.max = max;
            this.nextStart = new AtomicLong(0L);
        }

        public IndexProgressor initialize(IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, CursorContext cursorContext) {
            return this.init(client, Long.MIN_VALUE, Long.MAX_VALUE, indexOrder, cursorContext);
        }

        public IndexProgressor initializeBatch(IndexProgressor.EntityTokenClient client, int sizeHint, CursorContext cursorContext) {
            if (sizeHint == 0) {
                return IndexProgressor.EMPTY;
            }
            long size = DefaultTokenIndexReader.this.idLayout.roundUp(sizeHint);
            long start = this.nextStart.getAndAdd(size);
            long stop = Math.min(start + size, this.max);
            if (start >= this.max) {
                return IndexProgressor.EMPTY;
            }
            return this.init(client, start, stop, IndexOrder.NONE, cursorContext);
        }

        private IndexProgressor init(IndexProgressor.EntityTokenClient client, long start, long stop, IndexOrder indexOrder, CursorContext cursorContext) {
            Seeker<TokenScanKey, TokenScanValue> cursor;
            EntityRange range = new EntityRange(start, stop);
            try {
                cursor = DefaultTokenIndexReader.this.seekerForToken(range, this.tokenId, indexOrder, cursorContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new TokenScanValueIndexProgressor(cursor, client, indexOrder, range, DefaultTokenIndexReader.this.idLayout, this.tokenId);
        }
    }

    private class NativePartitionedTokenScan
    implements PartitionedTokenScan {
        private final EntityRange range = EntityRange.FULL;
        private final List<TokenScanKey> partitionEdges;
        private final AtomicInteger nextFrom = new AtomicInteger();

        NativePartitionedTokenScan(int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IOException {
            Preconditions.requirePositive((int)desiredNumberOfPartitions);
            int tokenId = query.tokenId();
            TokenScanKey fromInclusive = new TokenScanKey(tokenId, DefaultTokenIndexReader.this.idLayout.rangeOf(this.range.fromInclusive()));
            TokenScanKey toExclusive = new TokenScanKey(tokenId, DefaultTokenIndexReader.this.idLayout.rangeOf(this.range.toExclusive()) + 1L);
            this.partitionEdges = DefaultTokenIndexReader.this.index.partitionedSeek((Object)fromInclusive, (Object)toExclusive, desiredNumberOfPartitions, cursorContext);
        }

        NativePartitionedTokenScan(NativePartitionedTokenScan leadingPartition, TokenPredicate query) {
            int tokenId = query.tokenId();
            List<TokenScanKey> leadingEdges = leadingPartition.partitionEdges;
            this.partitionEdges = new ArrayList<TokenScanKey>(leadingEdges.size());
            for (TokenScanKey leadingEdge : leadingEdges) {
                this.partitionEdges.add(new TokenScanKey(tokenId, leadingEdge.idRange));
            }
        }

        public int getNumberOfPartitions() {
            return this.partitionEdges.size() - 1;
        }

        public IndexProgressor reservePartition(IndexProgressor.EntityTokenClient client, CursorContext cursorContext) {
            int from = this.nextFrom.getAndIncrement();
            int to = from + 1;
            if (to >= this.partitionEdges.size()) {
                return IndexProgressor.EMPTY;
            }
            try {
                TokenScanKey fromInclusive = this.partitionEdges.get(from);
                TokenScanKey toExclusive = this.partitionEdges.get(to);
                return new TokenScanValueIndexProgressor((Seeker<TokenScanKey, TokenScanValue>)DefaultTokenIndexReader.this.index.seek((Object)fromInclusive, (Object)toExclusive, cursorContext), client, IndexOrder.NONE, this.range, DefaultTokenIndexReader.this.idLayout, fromInclusive.tokenId);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

