/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public final class JobSchedulerFactory {
    private JobSchedulerFactory() {
    }

    public static JobScheduler createScheduler() {
        return JobSchedulerFactory.createCentralScheduler(Clocks.nanoClock(), (InternalLogProvider)NullLogProvider.getInstance());
    }

    public static JobScheduler createInitialisedScheduler() {
        return JobSchedulerFactory.createInitialisedScheduler(Clocks.nanoClock());
    }

    public static JobScheduler createInitialisedScheduler(SystemNanoClock clock) {
        return JobSchedulerFactory.createInitialisedScheduler(clock, (InternalLogProvider)NullLogProvider.getInstance());
    }

    public static JobScheduler createInitialisedScheduler(SystemNanoClock clock, InternalLogProvider logProvider) {
        CentralJobScheduler scheduler = JobSchedulerFactory.createCentralScheduler(clock, logProvider);
        scheduler.init();
        return scheduler;
    }

    private static CentralJobScheduler createCentralScheduler(SystemNanoClock clock, InternalLogProvider logProvider) {
        return new CentralJobScheduler(clock, logProvider);
    }
}

