/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import java.time.Clock;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.monitoring.tracing.DefaultTracerFactory;
import org.neo4j.kernel.monitoring.tracing.NullTracersFactory;
import org.neo4j.kernel.monitoring.tracing.TracerFactory;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.time.SystemNanoClock;

public class DefaultTracers
implements Tracers {
    private final PageCacheTracer pageCacheTracer;
    private final TracerFactory tracersFactory;
    private final SystemNanoClock clock;
    private final InternalLog log;

    public DefaultTracers(String desiredImplementationName, InternalLog log, Monitors monitors, JobScheduler jobScheduler, SystemNanoClock clock, Config config) {
        this.clock = clock;
        this.tracersFactory = DefaultTracers.createTracersFactory(desiredImplementationName, log);
        this.pageCacheTracer = this.tracersFactory.createPageCacheTracer(monitors, jobScheduler, clock, log, config);
        this.log = log;
    }

    @Override
    public PageCacheTracer getPageCacheTracer() {
        return this.pageCacheTracer;
    }

    @Override
    public LockTracer getLockTracer() {
        return this.tracersFactory.createLockTracer((Clock)this.clock);
    }

    @Override
    public DatabaseTracer getDatabaseTracer(NamedDatabaseId namedDatabaseId) {
        return this.tracersFactory.createDatabaseTracer(this.pageCacheTracer, (Clock)this.clock);
    }

    @Override
    public VersionStorageTracer getVersionStorageTracer(NamedDatabaseId namedDatabaseId) {
        return this.tracersFactory.createVersionStorageTracer(this.pageCacheTracer, this.log);
    }

    private static TracerFactory createTracersFactory(String desiredImplementationName, InternalLog msgLog) {
        if ("null".equalsIgnoreCase(desiredImplementationName)) {
            return new NullTracersFactory();
        }
        return DefaultTracers.selectTracerFactory(desiredImplementationName, msgLog);
    }

    private static TracerFactory selectTracerFactory(String desiredImplementationName, InternalLog msgLog) {
        if (StringUtils.isBlank((CharSequence)desiredImplementationName)) {
            return DefaultTracers.createDefaultTracerFactory();
        }
        try {
            return Services.load(TracerFactory.class, (String)desiredImplementationName).orElseGet(() -> {
                msgLog.warn("Using default tracer implementations instead of '%s'", new Object[]{desiredImplementationName});
                return DefaultTracers.createDefaultTracerFactory();
            });
        }
        catch (Exception e) {
            msgLog.warn(String.format("Failed to instantiate desired tracer implementations '%s', using default", desiredImplementationName), (Throwable)e);
            return DefaultTracers.createDefaultTracerFactory();
        }
    }

    private static TracerFactory createDefaultTracerFactory() {
        return new DefaultTracerFactory();
    }
}

