/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.io.pagecache.PageCursor;

public class LabelScanLayout
extends Layout.Adapter<LabelScanKey, LabelScanValue> {
    private static final String IDENTIFIER_NAME = "LSL";
    private static final int KEY_SIZE = 10;

    public LabelScanLayout() {
        super(true, Layout.namedIdentifier((String)IDENTIFIER_NAME, (int)64), 0, 1);
    }

    public int compare(LabelScanKey o1, LabelScanKey o2) {
        int labelComparison = Integer.compare(o1.labelId, o2.labelId);
        return labelComparison != 0 ? labelComparison : Long.compare(o1.idRange, o2.idRange);
    }

    public LabelScanKey newKey() {
        return new LabelScanKey();
    }

    public LabelScanKey copyKey(LabelScanKey key, LabelScanKey into) {
        into.labelId = key.labelId;
        into.idRange = key.idRange;
        return into;
    }

    public LabelScanValue newValue() {
        return new LabelScanValue();
    }

    public int keySize(LabelScanKey key) {
        return 10;
    }

    public int valueSize(LabelScanValue value) {
        return 8;
    }

    public void writeKey(PageCursor cursor, LabelScanKey key) {
        cursor.putInt(key.labelId);
        LabelScanLayout.put6ByteLong(cursor, key.idRange);
    }

    private static void put6ByteLong(PageCursor cursor, long value) {
        cursor.putInt((int)value);
        cursor.putShort((short)(value >>> 32));
    }

    public void writeValue(PageCursor cursor, LabelScanValue value) {
        cursor.putLong(value.bits);
    }

    public void readKey(PageCursor cursor, LabelScanKey into, int keySize) {
        into.labelId = cursor.getInt();
        into.idRange = LabelScanLayout.get6ByteLong(cursor);
    }

    private static long get6ByteLong(PageCursor cursor) {
        long low4b = (long)cursor.getInt() & 0xFFFFFFFFL;
        long high2b = cursor.getShort();
        return low4b | high2b << 32;
    }

    public void readValue(PageCursor cursor, LabelScanValue into, int valueSize) {
        into.bits = cursor.getLong();
    }

    public void initializeAsLowest(LabelScanKey key) {
        key.set(Integer.MIN_VALUE, Long.MIN_VALUE);
    }

    public void initializeAsHighest(LabelScanKey key) {
        key.set(Integer.MAX_VALUE, Long.MAX_VALUE);
    }
}

