/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.log4j.Neo4jConfiguration;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public class RotatingLogFileWriter
implements Closeable {
    private static final String APPENDER_NAME = "rotatingWriter";
    private final ExtendedLogger log;
    private final Neo4jLoggerContext ctx;

    public RotatingLogFileWriter(FileSystemAbstraction fs, Path logPath, long rotationThreshold, int maxArchives, String fileSuffix, String header) {
        this.ctx = RotatingLogFileWriter.setupLogFile(fs, logPath, rotationThreshold, maxArchives, fileSuffix, header);
        this.log = this.ctx.getLogger("");
    }

    public void printf(String pattern, Object ... params) {
        this.log.printf(Level.DEBUG, pattern, params);
    }

    @Override
    public void close() throws IOException {
        this.ctx.close();
    }

    private static Neo4jLoggerContext setupLogFile(FileSystemAbstraction fileSystemAbstraction, Path logPath, long rotationThreshold, int maxArchives, String fileSuffix, String header) {
        try {
            OutputStreamAppender appender;
            OutputStream additionalCloseable = null;
            Neo4jConfiguration configuration = new Neo4jConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration((Configuration)configuration).withHeader(header).build();
            if (fileSystemAbstraction instanceof DefaultFileSystemAbstraction) {
                appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("rotatingWriter." + logPath.getFileName().toString())).setLayout((Layout)layout)).withFileName(logPath.toString()).withFilePattern(RotatingLogFileWriter.escapePattern(logPath.toString()) + ".%02i" + RotatingLogFileWriter.escapePattern(fileSuffix)).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)String.valueOf(rotationThreshold))).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(maxArchives)).withFileIndex("min").build()).build();
            } else {
                OutputStream outputStream;
                fileSystemAbstraction.mkdirs(logPath.getParent());
                additionalCloseable = outputStream = fileSystemAbstraction.openAsOutputStream(logPath, true);
                appender = ((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)OutputStreamAppender.newBuilder().setName("rotatingWriter." + logPath.getFileName().toString())).setLayout((Layout)layout)).setTarget(outputStream).build();
            }
            appender.start();
            configuration.addAppender((Appender)appender);
            LoggerConfig rootLogger = configuration.getRootLogger();
            rootLogger.addAppender((Appender)appender, null, null);
            rootLogger.setLevel(Level.DEBUG);
            LoggerContext context = new LoggerContext("LoggerContext");
            context.setConfiguration((Configuration)configuration);
            return new Neo4jLoggerContext((org.apache.logging.log4j.spi.LoggerContext)context, additionalCloseable, "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String escapePattern(String pattern) {
        return pattern.replace("%", "%%");
    }
}

