/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.kernel.spi.legacyindex.IndexProviders;

public class LuceneKernelExtension
extends LifecycleAdapter {
    private final File storeDir;
    private final Config config;
    private final Supplier<IndexConfigStore> indexStore;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final IndexProviders indexProviders;
    private final OperationalMode operationalMode;

    public LuceneKernelExtension(File storeDir, Config config, Supplier<IndexConfigStore> indexStore, FileSystemAbstraction fileSystemAbstraction, IndexProviders indexProviders) {
        this(storeDir, config, indexStore, fileSystemAbstraction, indexProviders, OperationalMode.single);
    }

    public LuceneKernelExtension(File storeDir, Config config, Supplier<IndexConfigStore> indexStore, FileSystemAbstraction fileSystemAbstraction, IndexProviders indexProviders, OperationalMode operationalMode) {
        this.storeDir = storeDir;
        this.config = config;
        this.indexStore = indexStore;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.indexProviders = indexProviders;
        this.operationalMode = operationalMode;
    }

    public void init() {
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation(this.storeDir, this.config, this.indexStore, this.fileSystemAbstraction, this.operationalMode);
        this.indexProviders.registerIndexProvider("lucene", (IndexImplementation)indexImplementation);
    }

    public void shutdown() {
        this.indexProviders.unregisterIndexProvider("lucene");
    }
}

