/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.function.Factory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.ReadOnlyDatabaseSchemaIndex;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

public class LuceneSchemaIndexBuilder
extends AbstractLuceneIndexBuilder<LuceneSchemaIndexBuilder> {
    private final IndexDescriptor descriptor;
    private IndexSamplingConfig samplingConfig;
    private Factory<IndexWriterConfig> writerConfigFactory = IndexWriterConfigs::standard;

    private LuceneSchemaIndexBuilder(IndexDescriptor descriptor, Config config) {
        super(config);
        this.descriptor = descriptor;
        this.samplingConfig = new IndexSamplingConfig(config);
    }

    public static LuceneSchemaIndexBuilder create(IndexDescriptor descriptor, Config config) {
        return new LuceneSchemaIndexBuilder(descriptor, config);
    }

    public LuceneSchemaIndexBuilder withSamplingConfig(IndexSamplingConfig samplingConfig) {
        this.samplingConfig = samplingConfig;
        return this;
    }

    public LuceneSchemaIndexBuilder withWriterConfig(Factory<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public SchemaIndex build() {
        if (this.isReadOnly()) {
            return new ReadOnlyDatabaseSchemaIndex(this.storageBuilder.build(), this.descriptor, this.samplingConfig, new ReadOnlyIndexPartitionFactory());
        }
        PartitionedIndexStorage storage = this.storageBuilder.build();
        return new WritableDatabaseSchemaIndex(storage, this.descriptor, this.samplingConfig, new WritableIndexPartitionFactory(this.writerConfigFactory));
    }
}

