/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;
import org.neo4j.management.ClusterMemberInfo;

@ManagementInterface(name="High Availability")
@Description(value="Information about an instance participating in a HA cluster")
public interface HighAvailability {
    public static final String NAME = "High Availability";

    @Description(value="The identifier used to identify this server in the HA cluster")
    public String getInstanceId();

    @Description(value="Whether this instance is available or not")
    public boolean isAvailable();

    @Description(value="Whether this instance is alive or not")
    public boolean isAlive();

    @Description(value="The role this instance has in the cluster")
    public String getRole();

    @Description(value="The time when the data on this instance was last updated from the master")
    public String getLastUpdateTime();

    @Description(value="The latest transaction id present in this instance's store")
    public long getLastCommittedTxId();

    @Description(value="Information about all instances in this cluster")
    public ClusterMemberInfo[] getInstancesInCluster();

    @Description(value="(If this is a slave) Update the database on this instance with the latest transactions from the master")
    public String update();
}

