/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.util.Arrays;
import org.neo4j.ogm.autoindex.AutoIndexMode;
import org.neo4j.ogm.config.Configuration;

public class AutoIndexConfiguration {
    private static final String[] AUTO_INDEX = new String[]{"neo4j.ogm.indexes.auto", "indexes.auto"};
    private static final String[] GENERATED_INDEXES_OUTPUT_DIR = new String[]{"neo4j.ogm.indexes.auto.dump.dir", "indexes.auto.dump.dir"};
    private static final String[] GENERATED_INDEXES_OUTPUT_FILENAME = new String[]{"neo4j.ogm.indexes.auto.dump.filename", "indexes.auto.dump.filename"};
    private static final AutoIndexMode DEFAULT_AUTO_INDEX_VALUE = AutoIndexMode.NONE;
    private static final String DEFAULT_GENERATED_INDEXES_FILENAME = "generated_indexes.cql";
    public static final String DEFAULT_GENERATED_INDEXES_DIR = ".";
    private final Configuration configuration;

    public AutoIndexConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public AutoIndexConfiguration setAutoIndex(String value) {
        if (AutoIndexMode.fromString(value) == null) {
            throw new RuntimeException("Invalid index value: " + value + ". Value must be one of: " + Arrays.toString((Object[])AutoIndexMode.values()));
        }
        this.configuration.set(AUTO_INDEX[0], value);
        return this;
    }

    public AutoIndexMode getAutoIndex() {
        if (this.configuration.get(AUTO_INDEX) == null) {
            return DEFAULT_AUTO_INDEX_VALUE;
        }
        return AutoIndexMode.fromString((String)this.configuration.get(AUTO_INDEX));
    }

    public AutoIndexConfiguration setDumpDir(String dumpDir) {
        this.configuration.set(GENERATED_INDEXES_OUTPUT_DIR[0], dumpDir);
        return this;
    }

    public String getDumpDir() {
        if (this.configuration.get(GENERATED_INDEXES_OUTPUT_DIR) == null) {
            return DEFAULT_GENERATED_INDEXES_DIR;
        }
        return (String)this.configuration.get(GENERATED_INDEXES_OUTPUT_DIR);
    }

    public AutoIndexConfiguration setDumpFilename(String dumpFilename) {
        this.configuration.set(GENERATED_INDEXES_OUTPUT_FILENAME[0], dumpFilename);
        return this;
    }

    public String getDumpFilename() {
        if (this.configuration.get(GENERATED_INDEXES_OUTPUT_FILENAME) == null) {
            return DEFAULT_GENERATED_INDEXES_FILENAME;
        }
        return (String)this.configuration.get(GENERATED_INDEXES_OUTPUT_FILENAME);
    }
}

