/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import org.neo4j.ogm.model.Property;

public class PropertyModel<K, V>
implements Property<K, V> {
    private K key;
    private V value;

    public static <K, V> PropertyModel<K, V> with(K key, V value) {
        return new PropertyModel<K, V>(key, value);
    }

    public PropertyModel(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s : %s", this.key, this.asParameter());
    }

    @Override
    public Object asParameter() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return this.value;
        }
        try {
            return Long.parseLong(this.value.toString());
        }
        catch (Exception e1) {
            try {
                return Double.parseDouble(this.value.toString());
            }
            catch (Exception e2) {
                return this.value.toString();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyModel property = (PropertyModel)o;
        return this.key.equals(property.key) && this.value.equals(property.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

