/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.support;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.neo4j.ogm.support.ClassUtils;

public final class ResourceUtils {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";

    public static URL getResourceUrl(String resourceLocation) throws FileNotFoundException {
        URL resourceUrl;
        Objects.requireNonNull(resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            resourceUrl = ResourceUtils.getClasspathResourceUrl(resourceLocation.substring(CLASSPATH_URL_PREFIX.length()));
        } else {
            try {
                resourceUrl = new URL(resourceLocation);
            }
            catch (MalformedURLException e) {
                resourceUrl = ResourceUtils.getClasspathResourceUrl(resourceLocation);
            }
        }
        return resourceUrl;
    }

    private static URL getClasspathResourceUrl(String path) throws FileNotFoundException {
        URL url;
        ClassLoader cl = ClassUtils.getDefaultClassLoader();
        URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
        if (url == null) {
            String description = "class path resource [" + path + "]";
            throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    private ResourceUtils() {
    }
}

