/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Collection;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.GraphRowListModelMapper;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.DefaultGraphRowListModelRequest;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class LoadByTypeDelegate
implements Capability.LoadByType {
    private final Neo4jSession session;

    public LoadByTypeDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        String entityType = this.session.entityType(type.getName());
        QueryStatements queryStatements = this.session.queryStatementsFor(type);
        this.session.resolvePropertyAnnotations(type, sortOrder);
        if (filters.isEmpty()) {
            PagingAndSortingQuery qry = queryStatements.findByType(entityType, depth).setSortOrder(sortOrder).setPagination(pagination);
            if (depth == 0 || pagination == null && sortOrder.toString().length() == 0) {
                try (Response response = this.session.requestHandler().execute((GraphModelRequest)qry);){
                    Collection collection = (Collection)new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
                    return collection;
                }
            }
            DefaultGraphRowListModelRequest graphRowListModelRequest = new DefaultGraphRowListModelRequest(qry.getStatement(), qry.getParameters());
            try (Response response = this.session.requestHandler().execute((GraphRowListModelRequest)graphRowListModelRequest);){
                Collection x2 = (Collection)new GraphRowListModelMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphRowListModel>)response);
                return x2;
            }
        }
        this.session.resolvePropertyAnnotations(type, filters);
        PagingAndSortingQuery query = queryStatements.findByType(entityType, filters, depth).setSortOrder(sortOrder).setPagination(pagination);
        if (depth != 0) {
            try (Response response = this.session.requestHandler().execute((GraphRowListModelRequest)query);){
                Collection collection = (Collection)new GraphRowListModelMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphRowListModel>)response);
                return collection;
            }
        }
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)query);){
            Collection collection = (Collection)new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            return collection;
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadAll(type, filters, new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadAll(type, filters, new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadAll(type, filters, sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadAll(type, filters, sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadAll(type, filters, new SortOrder(), pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadAll(type, filters, new SortOrder(), pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, filters, sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadAll(type, new Filters(), sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, depth);
    }
}

