/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

public class RelatedNodePropertyMatchClause
implements MatchClause {
    private String label;
    private int index;
    private StringBuilder clause;

    public RelatedNodePropertyMatchClause(String label, int nodeIdentifier) {
        this.label = label;
        this.index = nodeIdentifier;
        this.clause = new StringBuilder(String.format("MATCH (%s:`%s`) ", this.nodeIdentifier(), this.label));
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public MatchClause append(Filter filter) {
        this.clause.append(filter.toCypher(this.nodeIdentifier(), this.clause.indexOf(" WHERE ") == -1));
        return this;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }

    private String nodeIdentifier() {
        return "m" + this.index;
    }
}

