/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.utils;

public class RelationshipUtils {
    public static String inferRelationshipType(String memberName) {
        if (memberName.startsWith("get") || memberName.startsWith("set")) {
            return RelationshipUtils.toUpperSnakeCase(memberName.substring(3)).toString();
        }
        return RelationshipUtils.toUpperSnakeCase(memberName).toString();
    }

    public static String inferSetterName(String relationshipType) {
        StringBuilder setterName = RelationshipUtils.toQuasiCamelCase(new StringBuilder("set"), relationshipType);
        return setterName.toString();
    }

    public static String inferGetterName(String relationshipType) {
        StringBuilder getterName = RelationshipUtils.toQuasiCamelCase(new StringBuilder("get"), relationshipType);
        return getterName.toString();
    }

    public static String inferFieldName(String relationshipType) {
        StringBuilder fieldName = RelationshipUtils.toQuasiCamelCase(new StringBuilder(), relationshipType);
        fieldName.setCharAt(0, Character.toLowerCase(fieldName.charAt(0)));
        return fieldName.toString();
    }

    private static StringBuilder toQuasiCamelCase(StringBuilder sb, String name) {
        if (name != null && name.length() > 0) {
            if (!name.contains("_")) {
                sb.append(name.substring(0, 1).toUpperCase());
                sb.append(name.substring(1).toLowerCase());
            } else {
                String[] parts;
                for (String part : parts = name.split("_")) {
                    String test = part.toLowerCase();
                    RelationshipUtils.toQuasiCamelCase(sb, test);
                }
            }
        }
        return sb;
    }

    private static StringBuilder toUpperSnakeCase(String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null && name.length() > 0) {
            char[] arr$ = name.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character ch = Character.valueOf(arr$[i$]);
                if (Character.isLowerCase(ch.charValue())) {
                    ch = Character.valueOf(Character.toUpperCase(ch.charValue()));
                } else if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(ch);
            }
        }
        return sb;
    }
}

