/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context.register;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRegister<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(EntityRegister.class);
    private final Map<T, Object> register = new HashMap<T, Object>();

    public Object get(T id) {
        return this.register.get(id);
    }

    public boolean add(T id, Object entity) {
        Object existing = this.register.get(id);
        if (existing != null) {
            this.LOGGER.debug("Object already in node registry: {}, {}", id, entity);
            return false;
        }
        this.register.put(id, entity);
        this.LOGGER.debug("Added object to node registry: {}, {}", id, entity);
        return true;
    }

    public boolean contains(T id) {
        return this.register.containsKey(id);
    }

    public void remove(T id) {
        this.LOGGER.debug("Removed object with id {}", id);
        this.register.remove(id);
    }

    public void clear() {
        this.LOGGER.debug("Register has been cleared");
        this.register.clear();
    }

    public Iterator<T> iterator() {
        return this.register.keySet().iterator();
    }
}

