/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context.register;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.MetaData;

public class TypeRegister {
    private final Map<Class<?>, Map<Object, Object>> register = new HashMap();

    public void remove(MetaData metaData, Class type, Object id) {
        Map<Object, Object> entities = this.register.get(type);
        if (entities != null && type.getSuperclass() != null && metaData != null && metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            entities.remove(id);
            this.remove(metaData, type.getSuperclass(), id);
        }
    }

    public Map<Object, Object> get(Class<?> type) {
        return Collections.unmodifiableMap(this.objectMap(type));
    }

    public void clear() {
        this.register.clear();
    }

    public void add(MetaData metaData, Class type, Object entity, Object id) {
        this.objectMap(type).put(id, entity);
        if (type.getSuperclass() != null && metaData != null && metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            this.add(metaData, type.getSuperclass(), entity, id);
        }
        if (type.getInterfaces() != null && metaData != null) {
            for (Class<?> interfaceClass : type.getInterfaces()) {
                if (metaData.classInfo(interfaceClass.getName()) == null) continue;
                this.add(metaData, interfaceClass, entity, id);
            }
        }
    }

    public void delete(Class<?> type) {
        this.register.keySet().remove(type);
    }

    private Map<Object, Object> objectMap(Class<?> type) {
        Map<Object, Object> objectMap = this.register.get(type);
        if (objectMap == null) {
            objectMap = new HashMap<Object, Object>();
            this.register.put(type, objectMap);
        }
        return objectMap;
    }
}

