/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Method;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.utils.ClassUtils;
import org.neo4j.ogm.utils.RelationshipUtils;

public class MethodInfo {
    private static final String primitiveGetters = "()I,()J,()S,()B,()C,()F,()D,()Z,()[I,()[J,()[S,()[B,()[C,()[F,()[D,()[Z";
    private static final String primitiveSetters = "(I)V,(J)V,(S)V,(B)V,(C)V,(F)V,(D)V,(Z)V,([I)V,([J)V,([S)V,([B)V,([C)V,([F)V,([D)V,([Z)V";
    private static final String simpleJavaObjectGetters = "()Ljava/lang/Object;()Ljava/lang/Character;()Ljava/lang/Byte;()Ljava/lang/Short;()Ljava/lang/Integer;()Ljava/lang/Long;()Ljava/lang/Float;()Ljava/lang/Double;()Ljava/lang/Boolean;()Ljava/lang/String;()[Ljava/lang/Object;()[Ljava/lang/Character;()[Ljava/lang/Byte;()[Ljava/lang/Short;()[Ljava/lang/Integer;()[Ljava/lang/Long;()[Ljava/lang/Float;()[Ljava/lang/Double;()[Ljava/lang/Boolean;()[Ljava/lang/String;";
    private static final String simpleJavaObjectSetters = "(Ljava/lang/Object;)V(Ljava/lang/Character;)V(Ljava/lang/Byte;)V(Ljava/lang/Short;)V(Ljava/lang/Integer;)V(Ljava/lang/Long;)V)(Ljava/lang/Float;)V(Ljava/lang/Double;)V(Ljava/lang/Boolean;)V(Ljava/lang/String;)V([Ljava/lang/Object;)V([Ljava/lang/Character;)V([Ljava/lang/Byte;)V([Ljava/lang/Short;)V([Ljava/lang/Integer;)V([Ljava/lang/Long;)V([Ljava/lang/Float;)V([Ljava/lang/Double;)V([Ljava/lang/Boolean;)V([Ljava/lang/String;)V";
    private final String name;
    private final String descriptor;
    private final ObjectAnnotations annotations;
    private final String typeParameterDescriptor;
    private Method method;
    private AttributeConverter<?, ?> propertyConverter;
    private CompositeAttributeConverter<?> compositeConverter;

    public MethodInfo(String name, String descriptor, String typeParameterDescriptor, ObjectAnnotations annotations) {
        this.name = name;
        this.descriptor = descriptor;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        if (!this.getAnnotations().isEmpty()) {
            Object converter = this.getAnnotations().getConverter();
            if (converter instanceof AttributeConverter) {
                this.setPropertyConverter((AttributeConverter)converter);
            } else if (converter instanceof CompositeAttributeConverter) {
                this.setCompositeConverter((CompositeAttributeConverter)converter);
            } else if (converter != null) {
                throw new IllegalStateException(String.format("The converter for field %s is neither an instance of AttributeConverter or CompositeAttributeConverter", this.name));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.isSimpleSetter() || this.isSimpleGetter()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Property")) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            if (this.name.startsWith("get") || this.name.startsWith("set")) {
                StringBuilder sb = new StringBuilder(this.name.substring(3));
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                return sb.toString();
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (!this.isSimpleSetter() && !this.isSimpleGetter()) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.isSimpleSetter() && !this.isSimpleGetter() && this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean isEquallyNamed(MethodInfo other) {
        return other != null && this.getName().equals(other.getName());
    }

    public boolean isGetter() {
        return this.getName().startsWith("get") && this.descriptor.startsWith("()");
    }

    public boolean isSetter() {
        return this.getName().startsWith("set") && this.descriptor.endsWith(")V");
    }

    public boolean isSimpleGetter() {
        return primitiveGetters.contains(this.descriptor) || this.hasPropertyConverter() || this.hasCompositeConverter() || this.returnsSimpleJavaType();
    }

    public boolean isSimpleSetter() {
        return primitiveSetters.contains(this.descriptor) || this.hasPropertyConverter() || this.hasCompositeConverter() || this.acceptsSimpleJavaType();
    }

    private boolean returnsSimpleJavaType() {
        return simpleJavaObjectGetters.contains(this.descriptor) && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && simpleJavaObjectGetters.contains(this.typeParameterDescriptor);
    }

    private boolean acceptsSimpleJavaType() {
        return simpleJavaObjectSetters.contains(this.descriptor) && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && simpleJavaObjectSetters.contains(this.typeParameterDescriptor);
    }

    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    void setPropertyConverter(AttributeConverter<?, ?> propertyConverter) {
        if (this.propertyConverter == null && this.compositeConverter == null && propertyConverter != null) {
            this.propertyConverter = propertyConverter;
        }
    }

    public CompositeAttributeConverter getCompositeConverter() {
        return this.compositeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter<?> converter) {
        if (this.propertyConverter == null && this.compositeConverter == null && converter != null) {
            this.compositeConverter = converter;
        }
    }

    public boolean hasCompositeConverter() {
        return this.compositeConverter != null;
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "(L" + type.getName().replace(".", "/") + ";)V";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.typeParameterDescriptor != null && this.typeParameterDescriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.typeParameterDescriptor == null || !this.typeParameterDescriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "([L" + type.getName().replace(".", "/") + ";)V";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "([L" + iface.getName().replace(".", "/") + ";)V";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isIterable() {
        String descriptorClass = this.getCollectionClassname();
        try {
            Class descriptorClazz = MetaDataClassLoader.loadClass((String)descriptorClass);
            if (Iterable.class.isAssignableFrom(descriptorClazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public String getCollectionClassname() {
        String descriptorClass = this.descriptor.replace("/", ".");
        if (descriptorClass.startsWith("(L")) {
            descriptorClass = descriptorClass.substring(2, descriptorClass.length() - 3);
        }
        if (descriptorClass.startsWith("()L")) {
            descriptorClass = descriptorClass.substring(3, descriptorClass.length() - 1);
        }
        return descriptorClass;
    }

    public boolean isScalar() {
        return this.typeParameterDescriptor == null && !this.isArray();
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public boolean isArray() {
        return this.descriptor.startsWith("()[") || this.descriptor.startsWith("([");
    }

    public String getTypeDescriptor() {
        if (!this.isIterable() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }

    public Method getMethod(String className) {
        if (this.method != null) {
            return this.method;
        }
        try {
            if (this.isSetter()) {
                this.method = MetaDataClassLoader.loadClass((String)className).getMethod(this.name, ClassUtils.getType(this.descriptor));
                return this.method;
            }
            if (this.isGetter()) {
                this.method = MetaDataClassLoader.loadClass((String)className).getMethod(this.name, new Class[0]);
                return this.method;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Only JavaBean-style getter and setter methods can be invoked");
    }
}

