/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.neo4j.ogm.context.WriteProtectionTarget;
import org.neo4j.ogm.session.WriteProtectionStrategy;

class DefaultWriteProtectionStrategyImpl
implements WriteProtectionStrategy {
    private final Map<WriteProtectionTarget, Predicate<Object>> writeProtectionPredicates = new HashMap<WriteProtectionTarget, Predicate<Object>>();

    DefaultWriteProtectionStrategyImpl() {
    }

    @Override
    public BiFunction<WriteProtectionTarget, Class<?>, Predicate<Object>> get() {
        return (mode, targetEntity) -> this.writeProtectionPredicates.getOrDefault(mode, t -> false);
    }

    void addProtection(WriteProtectionTarget key, Predicate<Object> value) {
        this.writeProtectionPredicates.put(key, value);
    }

    void removeProtection(WriteProtectionTarget key) {
        this.writeProtectionPredicates.remove((Object)key);
    }

    boolean isEmpty() {
        return this.writeProtectionPredicates.isEmpty();
    }
}

