/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

public class NestedPropertyPathMatchClause
implements MatchClause {
    private int index;
    private String label;
    private final boolean isRelationship;
    private StringBuilder clause;

    NestedPropertyPathMatchClause(int index, String label, boolean isRelationship) {
        this.index = index;
        this.label = label;
        this.isRelationship = isRelationship;
        this.clause = isRelationship ? new StringBuilder(String.format("MATCH ()-[%s:`%s`]-() ", this.relationshipIdentifier(), this.label)) : new StringBuilder(String.format("MATCH (%s:`%s`) ", this.nodeIdentifier(), this.label));
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public MatchClause append(Filter filter) {
        if (this.isRelationship) {
            this.clause.append(filter.toCypher(this.relationshipIdentifier(), this.clause.indexOf(" WHERE ") == -1));
        } else {
            this.clause.append(filter.toCypher(this.nodeIdentifier(), this.clause.indexOf(" WHERE ") == -1));
        }
        return this;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }

    private String nodeIdentifier() {
        return "m" + this.index;
    }

    private String relationshipIdentifier() {
        return "r" + this.index;
    }
}

