/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.ComponentInjectionException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.FieldSetter;

class FieldInjections {
    private final ComponentRegistry components;

    FieldInjections(ComponentRegistry components) {
        this.components = components;
    }

    List<FieldSetter> setters(Class<?> cls) throws ProcedureException {
        LinkedList<FieldSetter> setters = new LinkedList<FieldSetter>();
        Class<?> currentClass = cls;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!field.isAnnotationPresent(Context.class)) continue;
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "The field `%s` in the class named `%s` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", new Object[]{field.getName(), cls.getSimpleName()});
                }
                this.assertValidForInjection(cls, field);
                setters.add(this.createInjector(cls, field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return setters;
    }

    private FieldSetter createInjector(Class<?> cls, Field field) throws ProcedureException {
        ThrowingFunction<org.neo4j.kernel.api.procedure.Context, ?, ProcedureException> provider = this.components.providerFor(field.getType());
        if (provider == null) {
            throw new ComponentInjectionException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to set up injection for procedure `%s`, the field `%s` has type `%s` which is not a known injectable component.", new Object[]{cls.getSimpleName(), field.getName(), field.getType()});
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to set up injection for `%s`, failed to access field `%s", new Object[]{cls.getSimpleName(), field.getName()});
        }
        return new FieldSetter(field, provider);
    }

    private void assertValidForInjection(Class<?> cls, Field field) throws ProcedureException {
        if (!field.isAnnotationPresent(Context.class)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Field `%s` on `%s` is not annotated as a @" + Context.class.getSimpleName() + " and is not static. If you want to store state along with your procedure, please use a static field.", new Object[]{field.getName(), cls.getSimpleName()});
        }
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Field `%s` on `%s` must be non-final and public.", new Object[]{field.getName(), cls.getSimpleName()});
        }
    }
}

