/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a DateTime instant.")
class DateTimeFunction
extends TemporalFunction<DateTimeValue> {
    private static final String CATEGORY = Category.TEMPORAL();

    DateTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, defaultZone);
    }

    @Override
    protected DateTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateTimeValue.now((Clock)clock, defaultZone) : DateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    void registerMore(GlobalProcedures globalProcedures) throws ProcedureException {
        globalProcedures.registerBuiltIn((CallableUserFunction)new FromEpoch());
        globalProcedures.registerBuiltIn((CallableUserFunction)new FromEpochMillis());
    }

    private static class FromEpochMillis
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the milliseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"milliseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepochmillis"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, null, new String[0], "Create a DateTime given the milliseconds since the start of the epoch.", CATEGORY, true);

        private FromEpochMillis() {
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public boolean threadSafe() {
            return true;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 1 && input[0] instanceof IntegralValue) {
                IntegralValue milliseconds = (IntegralValue)input[0];
                return DateTimeValue.ofEpochMillis((IntegralValue)milliseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
        }
    }

    private static class FromEpoch
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the seconds and nanoseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"seconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber), FieldSignature.inputField((String)"nanoseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepoch"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, null, new String[0], "Create a DateTime given the seconds and nanoseconds since the start of the epoch.", CATEGORY, true);

        private FromEpoch() {
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public boolean threadSafe() {
            return true;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 2 && input[0] instanceof IntegralValue && input[1] instanceof IntegralValue) {
                IntegralValue seconds = (IntegralValue)input[0];
                IntegralValue nanoseconds = (IntegralValue)input[1];
                return DateTimeValue.ofEpoch((IntegralValue)seconds, (IntegralValue)nanoseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
        }
    }
}

