/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final ConstraintDescriptor constraint;
    private final String cause;

    public CreateConstraintFailureException(ConstraintDescriptor constraint, Throwable cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
        this.cause = null;
    }

    public CreateConstraintFailureException(ConstraintDescriptor constraint, String cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, null, "Unable to create constraint %s: %s", constraint, cause);
        this.constraint = constraint;
        this.cause = cause;
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        Object message = "Unable to create " + this.constraint.prettyPrint(tokenNameLookup);
        if (this.cause != null) {
            message = String.format("%s:%n%s", message, this.cause);
        }
        if (this.getCause() instanceof KernelException) {
            KernelException cause = (KernelException)this.getCause();
            return String.format("%s:%n%s", message, cause.getUserMessage(tokenNameLookup));
        }
        return message;
    }
}

