/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.constraints.TypeRepresentation;

public enum SchemaValueType implements TypeRepresentation
{
    BOOLEAN("BOOLEAN", TypeRepresentation.Ordering.BOOLEAN_ORDER),
    STRING("STRING", TypeRepresentation.Ordering.STRING_ORDER),
    INTEGER("INTEGER", TypeRepresentation.Ordering.INTEGER_ORDER),
    FLOAT("FLOAT", TypeRepresentation.Ordering.FLOAT_ORDER),
    DATE("DATE", TypeRepresentation.Ordering.DATE_ORDER),
    LOCAL_TIME("LOCAL TIME", TypeRepresentation.Ordering.LOCAL_TIME_ORDER),
    ZONED_TIME("ZONED TIME", TypeRepresentation.Ordering.ZONED_TIME_ORDER),
    LOCAL_DATETIME("LOCAL DATETIME", TypeRepresentation.Ordering.LOCAL_DATETIME_ORDER),
    ZONED_DATETIME("ZONED DATETIME", TypeRepresentation.Ordering.ZONED_DATETIME_ORDER),
    DURATION("DURATION", TypeRepresentation.Ordering.DURATION_ORDER),
    POINT("POINT", TypeRepresentation.Ordering.POINT_ORDER),
    LIST_BOOLEAN("LIST<BOOLEAN NOT NULL>", TypeRepresentation.Ordering.LIST_BOOLEAN_ORDER),
    LIST_STRING("LIST<STRING NOT NULL>", TypeRepresentation.Ordering.LIST_STRING_ORDER),
    LIST_INTEGER("LIST<INTEGER NOT NULL>", TypeRepresentation.Ordering.LIST_INTEGER_ORDER),
    LIST_FLOAT("LIST<FLOAT NOT NULL>", TypeRepresentation.Ordering.LIST_FLOAT_ORDER),
    LIST_DATE("LIST<DATE NOT NULL>", TypeRepresentation.Ordering.LIST_DATE_ORDER),
    LIST_LOCAL_TIME("LIST<LOCAL TIME NOT NULL>", TypeRepresentation.Ordering.LIST_LOCAL_TIME_ORDER),
    LIST_ZONED_TIME("LIST<ZONED TIME NOT NULL>", TypeRepresentation.Ordering.LIST_ZONED_TIME_ORDER),
    LIST_LOCAL_DATETIME("LIST<LOCAL DATETIME NOT NULL>", TypeRepresentation.Ordering.LIST_LOCAL_DATETIME_ORDER),
    LIST_ZONED_DATETIME("LIST<ZONED DATETIME NOT NULL>", TypeRepresentation.Ordering.LIST_ZONED_DATETIME_ORDER),
    LIST_DURATION("LIST<DURATION NOT NULL>", TypeRepresentation.Ordering.LIST_DURATION_ORDER),
    LIST_POINT("LIST<POINT NOT NULL>", TypeRepresentation.Ordering.LIST_POINT_ORDER);

    private final String userDescription;
    private final TypeRepresentation.Ordering order;

    private SchemaValueType(String userDescription, TypeRepresentation.Ordering order) {
        this.userDescription = userDescription;
        this.order = order;
    }

    @Override
    public String userDescription() {
        return this.userDescription;
    }

    @Override
    public TypeRepresentation.Ordering order() {
        return this.order;
    }

    public String serialize() {
        return this.name();
    }

    public String toString() {
        return this.userDescription;
    }

    public static SchemaValueType fromPublicApi(PropertyType propertyType) {
        return switch (propertyType) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.BOOLEAN -> BOOLEAN;
            case PropertyType.STRING -> STRING;
            case PropertyType.INTEGER -> INTEGER;
            case PropertyType.FLOAT -> FLOAT;
            case PropertyType.DURATION -> DURATION;
            case PropertyType.DATE -> DATE;
            case PropertyType.ZONED_DATETIME -> ZONED_DATETIME;
            case PropertyType.LOCAL_DATETIME -> LOCAL_DATETIME;
            case PropertyType.ZONED_TIME -> ZONED_TIME;
            case PropertyType.LOCAL_TIME -> LOCAL_TIME;
            case PropertyType.POINT -> POINT;
            case PropertyType.LIST_BOOLEAN_NOT_NULL -> LIST_BOOLEAN;
            case PropertyType.LIST_STRING_NOT_NULL -> LIST_STRING;
            case PropertyType.LIST_INTEGER_NOT_NULL -> LIST_INTEGER;
            case PropertyType.LIST_FLOAT_NOT_NULL -> LIST_FLOAT;
            case PropertyType.LIST_DATE_NOT_NULL -> LIST_DATE;
            case PropertyType.LIST_LOCAL_TIME_NOT_NULL -> LIST_LOCAL_TIME;
            case PropertyType.LIST_ZONED_TIME_NOT_NULL -> LIST_ZONED_TIME;
            case PropertyType.LIST_LOCAL_DATETIME_NOT_NULL -> LIST_LOCAL_DATETIME;
            case PropertyType.LIST_ZONED_DATETIME_NOT_NULL -> LIST_ZONED_DATETIME;
            case PropertyType.LIST_DURATION_NOT_NULL -> LIST_DURATION;
            case PropertyType.LIST_POINT_NOT_NULL -> LIST_POINT;
        };
    }

    public PropertyType toPublicApi() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOOLEAN -> PropertyType.BOOLEAN;
            case STRING -> PropertyType.STRING;
            case INTEGER -> PropertyType.INTEGER;
            case FLOAT -> PropertyType.FLOAT;
            case DURATION -> PropertyType.DURATION;
            case DATE -> PropertyType.DATE;
            case ZONED_DATETIME -> PropertyType.ZONED_DATETIME;
            case LOCAL_DATETIME -> PropertyType.LOCAL_DATETIME;
            case ZONED_TIME -> PropertyType.ZONED_TIME;
            case LOCAL_TIME -> PropertyType.LOCAL_TIME;
            case LIST_BOOLEAN -> PropertyType.LIST_BOOLEAN_NOT_NULL;
            case LIST_STRING -> PropertyType.LIST_STRING_NOT_NULL;
            case LIST_INTEGER -> PropertyType.LIST_INTEGER_NOT_NULL;
            case LIST_FLOAT -> PropertyType.LIST_FLOAT_NOT_NULL;
            case LIST_DATE -> PropertyType.LIST_DATE_NOT_NULL;
            case LIST_LOCAL_TIME -> PropertyType.LIST_LOCAL_TIME_NOT_NULL;
            case LIST_ZONED_TIME -> PropertyType.LIST_ZONED_TIME_NOT_NULL;
            case LIST_LOCAL_DATETIME -> PropertyType.LIST_LOCAL_DATETIME_NOT_NULL;
            case LIST_ZONED_DATETIME -> PropertyType.LIST_ZONED_DATETIME_NOT_NULL;
            case LIST_DURATION -> PropertyType.LIST_DURATION_NOT_NULL;
            case LIST_POINT -> PropertyType.LIST_POINT_NOT_NULL;
            case POINT -> PropertyType.POINT;
        };
    }
}

