/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import com.github.benmanes.caffeine.cache.Ticker;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.Realm;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.helpers.Service;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.FileRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.LdapRealm;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.SecurityProcedures;
import org.neo4j.server.security.enterprise.auth.ShiroCaffeineCache;
import org.neo4j.server.security.enterprise.auth.UserManagementProcedures;
import org.neo4j.server.security.enterprise.auth.plugin.PluginRealm;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationPlugin;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;
import org.neo4j.time.Clocks;

public class EnterpriseSecurityModule
extends SecurityModule {
    public static final String ROLE_STORE_FILENAME = "roles";
    private static final String DEFAULT_ADMIN_STORE_FILENAME = "admin.ini";
    private EnterpriseAuthAndUserManager authManager;
    protected SecurityConfig securityConfig;

    public EnterpriseSecurityModule() {
        super("enterprise-security-module", new String[0]);
    }

    public EnterpriseSecurityModule(String securityModuleId) {
        super(securityModuleId, new String[0]);
    }

    public void setup(SecurityModule.Dependencies dependencies) throws KernelException {
        Config config = dependencies.config();
        Procedures procedures = dependencies.procedures();
        LogProvider logProvider = dependencies.logService().getUserLogProvider();
        JobScheduler jobScheduler = dependencies.scheduler();
        FileSystemAbstraction fileSystem = dependencies.fileSystem();
        AccessCapability accessCapability = dependencies.accessCapability();
        SecurityLog securityLog = SecurityLog.create(config, dependencies.logService().getInternalLog(GraphDatabaseFacade.class), fileSystem, jobScheduler);
        this.life.add((Lifecycle)securityLog);
        this.authManager = this.newAuthManager(config, logProvider, securityLog, fileSystem, jobScheduler, accessCapability);
        this.life.add((Lifecycle)dependencies.dependencySatisfier().satisfyDependency((Object)this.authManager));
        procedures.registerComponent(SecurityLog.class, ctx -> securityLog, false);
        procedures.registerComponent(EnterpriseAuthManager.class, ctx -> this.authManager, false);
        procedures.registerComponent(EnterpriseSecurityContext.class, ctx -> this.asEnterprise((SecurityContext)ctx.get(Context.SECURITY_CONTEXT)), true);
        if (this.securityConfig.nativeAuthEnabled) {
            procedures.registerComponent(EnterpriseUserManager.class, ctx -> this.authManager.getUserManager(((SecurityContext)ctx.get(Context.SECURITY_CONTEXT)).subject(), ((SecurityContext)ctx.get(Context.SECURITY_CONTEXT)).isAdmin()), true);
            if (((List)config.get(SecuritySettings.auth_providers)).size() > 1) {
                procedures.registerProcedure(UserManagementProcedures.class, true, "%s only applies to native users.");
            } else {
                procedures.registerProcedure(UserManagementProcedures.class, true);
            }
        } else {
            procedures.registerComponent(EnterpriseUserManager.class, ctx -> EnterpriseUserManager.NOOP, true);
        }
        procedures.registerProcedure(SecurityProcedures.class, true);
    }

    public AuthManager authManager() {
        return this.authManager;
    }

    public UserManagerSupplier userManagerSupplier() {
        return this.authManager;
    }

    private EnterpriseSecurityContext asEnterprise(SecurityContext securityContext) {
        if (securityContext instanceof EnterpriseSecurityContext) {
            return (EnterpriseSecurityContext)securityContext;
        }
        throw new RuntimeException("Expected EnterpriseSecurityContext, got " + securityContext.getClass().getName());
    }

    public EnterpriseAuthAndUserManager newAuthManager(Config config, LogProvider logProvider, SecurityLog securityLog, FileSystemAbstraction fileSystem, JobScheduler jobScheduler, AccessCapability accessCapability) {
        List<Realm> orderedActiveRealms;
        this.securityConfig = this.getValidatedSecurityConfig(config);
        ArrayList<Realm> realms = new ArrayList<Realm>(this.securityConfig.authProviders.size() + 1);
        SecureHasher secureHasher = new SecureHasher();
        EnterpriseUserManager internalRealm = this.createInternalRealm(config, logProvider, fileSystem, jobScheduler, securityLog, accessCapability);
        if (internalRealm != null) {
            realms.add((Realm)internalRealm);
        }
        if (this.securityConfig.hasLdapProvider) {
            realms.add((Realm)new LdapRealm(config, securityLog, secureHasher));
        }
        if (!this.securityConfig.pluginAuthProviders.isEmpty()) {
            realms.addAll(EnterpriseSecurityModule.createPluginRealms(config, securityLog, secureHasher, this.securityConfig));
        }
        if ((orderedActiveRealms = EnterpriseSecurityModule.selectOrderedActiveRealms(this.securityConfig.authProviders, realms)).isEmpty()) {
            throw EnterpriseSecurityModule.illegalConfiguration("No valid auth provider is active.");
        }
        return new MultiRealmAuthManager(internalRealm, orderedActiveRealms, EnterpriseSecurityModule.createCacheManager(config), securityLog, (Boolean)config.get(SecuritySettings.security_log_successful_authentication), this.securityConfig.propertyAuthorization, this.securityConfig.propertyBlacklist);
    }

    protected SecurityConfig getValidatedSecurityConfig(Config config) {
        SecurityConfig securityConfig = new SecurityConfig(config);
        securityConfig.validate();
        return securityConfig;
    }

    private static List<Realm> selectOrderedActiveRealms(List<String> configuredRealms, List<Realm> availableRealms) {
        ArrayList<Realm> orderedActiveRealms = new ArrayList<Realm>(configuredRealms.size());
        block0: for (String configuredRealmName : configuredRealms) {
            for (Realm realm : availableRealms) {
                if (!configuredRealmName.equals(realm.getName())) continue;
                orderedActiveRealms.add(realm);
                continue block0;
            }
        }
        return orderedActiveRealms;
    }

    protected EnterpriseUserManager createInternalRealm(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem, JobScheduler jobScheduler, SecurityLog securityLog, AccessCapability accessCapability) {
        InternalFlatFileRealm internalRealm = null;
        if (this.securityConfig.hasNativeProvider) {
            internalRealm = EnterpriseSecurityModule.createInternalFlatFileRealm(config, logProvider, fileSystem, jobScheduler);
        }
        return internalRealm;
    }

    protected static InternalFlatFileRealm createInternalFlatFileRealm(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        return new InternalFlatFileRealm((UserRepository)CommunitySecurityModule.getUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem), EnterpriseSecurityModule.getRoleRepository(config, logProvider, fileSystem), (PasswordPolicy)new BasicPasswordPolicy(), EnterpriseSecurityModule.createAuthenticationStrategy(config), (Boolean)config.get(SecuritySettings.native_authentication_enabled), (Boolean)config.get(SecuritySettings.native_authorization_enabled), jobScheduler, (UserRepository)CommunitySecurityModule.getInitialUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem), EnterpriseSecurityModule.getDefaultAdminRepository(config, logProvider, fileSystem));
    }

    protected static AuthenticationStrategy createAuthenticationStrategy(Config config) {
        return new RateLimitedAuthenticationStrategy(Clocks.systemClock(), config);
    }

    private static CacheManager createCacheManager(Config config) {
        long ttl = ((Duration)config.get(SecuritySettings.auth_cache_ttl)).toMillis();
        boolean useTTL = (Boolean)config.get(SecuritySettings.auth_cache_use_ttl);
        int maxCapacity = (Integer)config.get(SecuritySettings.auth_cache_max_capacity);
        return new ShiroCaffeineCache.Manager(Ticker.systemTicker(), ttl, maxCapacity, useTTL);
    }

    private static List<PluginRealm> createPluginRealms(Config config, SecurityLog securityLog, SecureHasher secureHasher, SecurityConfig securityConfig) {
        boolean missingAuthorizingRealm;
        PluginRealm pluginRealm;
        ArrayList<PluginRealm> availablePluginRealms = new ArrayList<PluginRealm>();
        HashSet excludedClasses = new HashSet();
        if (securityConfig.pluginAuthentication && securityConfig.pluginAuthorization) {
            for (AuthPlugin plugin : Service.load(AuthPlugin.class)) {
                pluginRealm = new PluginRealm(plugin, config, securityLog, Clocks.systemClock(), secureHasher);
                availablePluginRealms.add(pluginRealm);
            }
        }
        if (securityConfig.pluginAuthentication) {
            for (AuthPlugin plugin : Service.load(AuthenticationPlugin.class)) {
                if (securityConfig.pluginAuthorization && plugin instanceof AuthorizationPlugin) {
                    pluginRealm = new PluginRealm((AuthenticationPlugin)plugin, (AuthorizationPlugin)plugin, config, securityLog, Clocks.systemClock(), secureHasher);
                    excludedClasses.add(plugin.getClass());
                } else {
                    pluginRealm = new PluginRealm((AuthenticationPlugin)plugin, null, config, securityLog, Clocks.systemClock(), secureHasher);
                }
                availablePluginRealms.add(pluginRealm);
            }
        }
        if (securityConfig.pluginAuthorization) {
            for (AuthPlugin plugin : Service.load(AuthorizationPlugin.class)) {
                if (excludedClasses.contains(plugin.getClass())) continue;
                availablePluginRealms.add(new PluginRealm(null, (AuthorizationPlugin)plugin, config, securityLog, Clocks.systemClock(), secureHasher));
            }
        }
        for (String pluginRealmName : securityConfig.pluginAuthProviders) {
            if (!availablePluginRealms.stream().noneMatch(r -> r.getName().equals(pluginRealmName))) continue;
            throw EnterpriseSecurityModule.illegalConfiguration(String.format("Failed to load auth plugin '%s'.", pluginRealmName));
        }
        List<PluginRealm> realms = availablePluginRealms.stream().filter(realm -> securityConfig.pluginAuthProviders.contains(realm.getName())).collect(Collectors.toList());
        boolean missingAuthenticatingRealm = securityConfig.onlyPluginAuthentication() && realms.stream().noneMatch(PluginRealm::canAuthenticate);
        boolean bl = missingAuthorizingRealm = securityConfig.onlyPluginAuthorization() && realms.stream().noneMatch(PluginRealm::canAuthorize);
        if (missingAuthenticatingRealm || missingAuthorizingRealm) {
            String missingProvider = missingAuthenticatingRealm && missingAuthorizingRealm ? "authentication or authorization" : (missingAuthenticatingRealm ? "authentication" : "authorization");
            throw EnterpriseSecurityModule.illegalConfiguration(String.format("No plugin %s provider loaded even though required by configuration.", missingProvider));
        }
        return realms;
    }

    public static RoleRepository getRoleRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileRoleRepository(fileSystem, EnterpriseSecurityModule.getRoleRepositoryFile(config), logProvider);
    }

    public static UserRepository getDefaultAdminRepository(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem) {
        return new FileUserRepository(fileSystem, EnterpriseSecurityModule.getDefaultAdminRepositoryFile(config), logProvider);
    }

    public static File getRoleRepositoryFile(Config config) {
        return new File((File)config.get(DatabaseManagementSystemSettings.auth_store_directory), ROLE_STORE_FILENAME);
    }

    private static File getDefaultAdminRepositoryFile(Config config) {
        return new File((File)config.get(DatabaseManagementSystemSettings.auth_store_directory), DEFAULT_ADMIN_STORE_FILENAME);
    }

    protected static IllegalArgumentException illegalConfiguration(String message) {
        return new IllegalArgumentException("Illegal configuration: " + message);
    }

    protected static class SecurityConfig {
        protected final List<String> authProviders;
        public final boolean hasNativeProvider;
        protected final boolean hasLdapProvider;
        protected final List<String> pluginAuthProviders;
        protected final boolean nativeAuthentication;
        protected final boolean nativeAuthorization;
        protected final boolean ldapAuthentication;
        protected final boolean ldapAuthorization;
        protected final boolean pluginAuthentication;
        protected final boolean pluginAuthorization;
        protected final boolean propertyAuthorization;
        private final String propertyAuthMapping;
        final Map<String, List<String>> propertyBlacklist = new HashMap<String, List<String>>();
        protected boolean nativeAuthEnabled;

        protected SecurityConfig(Config config) {
            this.authProviders = (List)config.get(SecuritySettings.auth_providers);
            this.hasNativeProvider = this.authProviders.contains("native");
            this.hasLdapProvider = this.authProviders.contains("ldap");
            this.pluginAuthProviders = this.authProviders.stream().filter(r -> r.startsWith("plugin-")).collect(Collectors.toList());
            this.nativeAuthentication = (Boolean)config.get(SecuritySettings.native_authentication_enabled);
            this.nativeAuthorization = (Boolean)config.get(SecuritySettings.native_authorization_enabled);
            this.nativeAuthEnabled = this.nativeAuthentication || this.nativeAuthorization;
            this.ldapAuthentication = (Boolean)config.get(SecuritySettings.ldap_authentication_enabled);
            this.ldapAuthorization = (Boolean)config.get(SecuritySettings.ldap_authorization_enabled);
            this.pluginAuthentication = (Boolean)config.get(SecuritySettings.plugin_authentication_enabled);
            this.pluginAuthorization = (Boolean)config.get(SecuritySettings.plugin_authorization_enabled);
            this.propertyAuthorization = (Boolean)config.get(SecuritySettings.property_level_authorization_enabled);
            this.propertyAuthMapping = (String)config.get(SecuritySettings.property_level_authorization_permissions);
        }

        protected void validate() {
            if (!(this.nativeAuthentication || this.ldapAuthentication || this.pluginAuthentication)) {
                throw EnterpriseSecurityModule.illegalConfiguration("All authentication providers are disabled.");
            }
            if (!(this.nativeAuthorization || this.ldapAuthorization || this.pluginAuthorization)) {
                throw EnterpriseSecurityModule.illegalConfiguration("All authorization providers are disabled.");
            }
            if (this.hasNativeProvider && !this.nativeAuthentication && !this.nativeAuthorization) {
                throw EnterpriseSecurityModule.illegalConfiguration("Native auth provider configured, but both authentication and authorization are disabled.");
            }
            if (this.hasLdapProvider && !this.ldapAuthentication && !this.ldapAuthorization) {
                throw EnterpriseSecurityModule.illegalConfiguration("LDAP auth provider configured, but both authentication and authorization are disabled.");
            }
            if (!(this.pluginAuthProviders.isEmpty() || this.pluginAuthentication || this.pluginAuthorization)) {
                throw EnterpriseSecurityModule.illegalConfiguration("Plugin auth provider configured, but both authentication and authorization are disabled.");
            }
            if (this.propertyAuthorization && !this.parsePropertyPermissions()) {
                throw EnterpriseSecurityModule.illegalConfiguration("Property level authorization is enabled but there is a error in the permissions mapping.");
            }
        }

        protected boolean parsePropertyPermissions() {
            if (this.propertyAuthMapping != null && !this.propertyAuthMapping.isEmpty()) {
                String rolePattern = "\\s*[a-zA-Z0-9_]+\\s*";
                String propertyPattern = "\\s*[a-zA-Z0-9_]+\\s*";
                String roleToPerm = rolePattern + "=" + propertyPattern + "(," + propertyPattern + ")*";
                String multiLine = roleToPerm + "(;" + roleToPerm + ")*";
                boolean valid = this.propertyAuthMapping.matches(multiLine);
                if (!valid) {
                    return false;
                }
                for (String rolesAndPermissions : this.propertyAuthMapping.split(";")) {
                    if (rolesAndPermissions.isEmpty()) continue;
                    String[] split = rolesAndPermissions.split("=");
                    String role = split[0].trim();
                    String permissions = split[1];
                    ArrayList<String> permissionsList = new ArrayList<String>();
                    for (String perm : permissions.split(",")) {
                        if (perm.isEmpty()) continue;
                        permissionsList.add(perm.trim());
                    }
                    this.propertyBlacklist.put(role, permissionsList);
                }
            }
            return true;
        }

        protected boolean onlyPluginAuthentication() {
            return !this.nativeAuthentication && !this.ldapAuthentication && this.pluginAuthentication;
        }

        protected boolean onlyPluginAuthorization() {
            return !this.nativeAuthorization && !this.ldapAuthorization && this.pluginAuthorization;
        }
    }
}

