/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.CachingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Initializable;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.graphdb.security.AuthProviderTimeoutException;
import org.neo4j.helpers.Strings;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.enterprise.api.security.EnterpriseLoginContext;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.PersonalUserManager;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationStrategy;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;
import org.neo4j.server.security.enterprise.auth.ShiroSubjectFactory;
import org.neo4j.server.security.enterprise.auth.StandardEnterpriseLoginContext;
import org.neo4j.server.security.enterprise.log.SecurityLog;

class MultiRealmAuthManager
implements EnterpriseAuthAndUserManager {
    private final EnterpriseUserManager userManager;
    private final Collection<Realm> realms;
    private final DefaultSecurityManager securityManager;
    private final CacheManager cacheManager;
    private final SecurityLog securityLog;
    private final boolean logSuccessfulLogin;
    private final boolean propertyAuthorization;
    private final Map<String, List<String>> roleToPropertyBlacklist;

    MultiRealmAuthManager(EnterpriseUserManager userManager, Collection<Realm> realms, CacheManager cacheManager, SecurityLog securityLog, boolean logSuccessfulLogin, boolean propertyAuthorization, Map<String, List<String>> roleToPropertyBlacklist) {
        this.userManager = userManager;
        this.realms = realms;
        this.cacheManager = cacheManager;
        this.securityManager = new DefaultSecurityManager(realms);
        this.securityLog = securityLog;
        this.logSuccessfulLogin = logSuccessfulLogin;
        this.propertyAuthorization = propertyAuthorization;
        this.roleToPropertyBlacklist = roleToPropertyBlacklist;
        this.securityManager.setSubjectFactory((SubjectFactory)new ShiroSubjectFactory());
        ((ModularRealmAuthenticator)this.securityManager.getAuthenticator()).setAuthenticationStrategy((AuthenticationStrategy)new ShiroAuthenticationStrategy());
        this.securityManager.setSubjectDAO(this.createSubjectDAO());
    }

    private SubjectDAO createSubjectDAO() {
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)sessionStorageEvaluator);
        return subjectDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseLoginContext login(Map<String, Object> authToken) throws InvalidAuthTokenException {
        try {
            StandardEnterpriseLoginContext securityContext;
            ShiroAuthToken token = new ShiroAuthToken(authToken);
            this.assertValidScheme(token);
            try {
                securityContext = new StandardEnterpriseLoginContext(this, (ShiroSubject)this.securityManager.login(null, (AuthenticationToken)token));
                AuthenticationResult authenticationResult = securityContext.subject().getAuthenticationResult();
                if (authenticationResult == AuthenticationResult.SUCCESS) {
                    if (this.logSuccessfulLogin) {
                        this.securityLog.info(securityContext.subject(), "logged in");
                    }
                } else if (authenticationResult == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
                    this.securityLog.info(securityContext.subject(), "logged in (password change required)");
                } else {
                    String errorMessage = ((StandardEnterpriseLoginContext.NeoShiroSubject)securityContext.subject()).getAuthenticationFailureMessage();
                    this.securityLog.error("[%s]: failed to log in: %s", Strings.escape((String)token.getPrincipal().toString()), errorMessage);
                }
                ((StandardEnterpriseLoginContext.NeoShiroSubject)securityContext.subject()).clearAuthenticationInfo();
            }
            catch (UnsupportedTokenException e) {
                this.securityLog.error("Unknown user failed to log in: %s", e.getMessage());
                Throwable cause = e.getCause();
                if (cause instanceof InvalidAuthTokenException) {
                    throw new InvalidAuthTokenException(cause.getMessage() + ": " + token);
                }
                throw AuthToken.invalidToken((String)(": " + token));
            }
            catch (ExcessiveAttemptsException e) {
                securityContext = new StandardEnterpriseLoginContext(this, new ShiroSubject((SecurityManager)this.securityManager, AuthenticationResult.TOO_MANY_ATTEMPTS));
                this.securityLog.error("[%s]: failed to log in: too many failed attempts", Strings.escape((String)token.getPrincipal().toString()));
            }
            catch (AuthenticationException e) {
                if (e.getCause() != null && e.getCause() instanceof AuthProviderTimeoutException) {
                    Throwable cause = e.getCause().getCause();
                    this.securityLog.error("[%s]: failed to log in: auth server timeout%s", Strings.escape((String)token.getPrincipal().toString()), cause != null && cause.getMessage() != null ? " (" + cause.getMessage() + ")" : "");
                    throw new AuthProviderTimeoutException(e.getCause().getMessage(), e.getCause());
                }
                if (e.getCause() != null && e.getCause() instanceof AuthProviderFailedException) {
                    Throwable cause = e.getCause().getCause();
                    this.securityLog.error("[%s]: failed to log in: auth server connection refused%s", Strings.escape((String)token.getPrincipal().toString()), cause != null && cause.getMessage() != null ? " (" + cause.getMessage() + ")" : "");
                    throw new AuthProviderFailedException(e.getCause().getMessage(), e.getCause());
                }
                securityContext = new StandardEnterpriseLoginContext(this, new ShiroSubject((SecurityManager)this.securityManager, AuthenticationResult.FAILURE));
                Throwable cause = e.getCause();
                Throwable causeCause = e.getCause() != null ? e.getCause().getCause() : null;
                String errorMessage = String.format("invalid principal or credentials%s%s", cause != null && cause.getMessage() != null ? " (" + cause.getMessage() + ")" : "", causeCause != null && causeCause.getMessage() != null ? " (" + causeCause.getMessage() + ")" : "");
                this.securityLog.error("[%s]: failed to log in: %s", Strings.escape((String)token.getPrincipal().toString()), errorMessage);
            }
            StandardEnterpriseLoginContext standardEnterpriseLoginContext = securityContext;
            return standardEnterpriseLoginContext;
        }
        finally {
            AuthToken.clearCredentials(authToken);
        }
    }

    private void assertValidScheme(ShiroAuthToken token) throws InvalidAuthTokenException {
        String scheme = token.getSchemeSilently();
        if (scheme == null) {
            throw AuthToken.invalidToken((String)("missing key `scheme`: " + token));
        }
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)("scheme='none' only allowed when auth is disabled: " + token));
        }
    }

    public void init() throws Throwable {
        for (Realm realm : this.realms) {
            if (realm instanceof Initializable) {
                ((Initializable)realm).init();
            }
            if (realm instanceof CachingRealm) {
                ((CachingRealm)realm).setCacheManager(this.cacheManager);
            }
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).initialize();
        }
    }

    public void start() throws Throwable {
        for (Realm realm : this.realms) {
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).start();
        }
    }

    public void stop() throws Throwable {
        for (Realm realm : this.realms) {
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).stop();
        }
    }

    public void shutdown() throws Throwable {
        for (Realm realm : this.realms) {
            if (realm instanceof CachingRealm) {
                ((CachingRealm)realm).setCacheManager(null);
            }
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).shutdown();
        }
    }

    @Override
    public EnterpriseUserManager getUserManager(AuthSubject authSubject, boolean isUserManager) {
        return new PersonalUserManager(this.userManager, authSubject, this.securityLog, isUserManager);
    }

    @Override
    public EnterpriseUserManager getUserManager() {
        return this.userManager;
    }

    public void clearAuthCache() {
        for (Realm realm : this.realms) {
            Cache cache;
            if (realm instanceof AuthenticatingRealm && (cache = ((AuthenticatingRealm)realm).getAuthenticationCache()) != null) {
                cache.clear();
            }
            if (!(realm instanceof AuthorizingRealm) || (cache = ((AuthorizingRealm)realm).getAuthorizationCache()) == null) continue;
            cache.clear();
        }
    }

    public Collection<AuthorizationInfo> getAuthorizationInfo(PrincipalCollection principalCollection) {
        ArrayList<AuthorizationInfo> infoList = new ArrayList<AuthorizationInfo>(1);
        for (Realm realm : this.realms) {
            AuthorizationInfo info;
            if (!(realm instanceof ShiroAuthorizationInfoProvider) || (info = ((ShiroAuthorizationInfoProvider)realm).getAuthorizationInfoSnapshot(principalCollection)) == null) continue;
            infoList.add(info);
        }
        return infoList;
    }

    IntPredicate getPropertyPermissions(Set<String> roles, ToIntFunction<String> tokenLookup) {
        if (this.propertyAuthorization) {
            IntHashSet blackListed = new IntHashSet();
            for (String role : roles) {
                if (!this.roleToPropertyBlacklist.containsKey(role)) continue;
                assert (this.roleToPropertyBlacklist.get(role) != null) : "Blacklist has to contain properties";
                for (String propName : this.roleToPropertyBlacklist.get(role)) {
                    try {
                        blackListed.add(tokenLookup.applyAsInt(propName));
                    }
                    catch (Exception e) {
                        this.securityLog.error("Error in setting up property permissions, '" + propName + "' is not a valid property name.");
                    }
                }
            }
            return arg_0 -> MultiRealmAuthManager.lambda$getPropertyPermissions$0((MutableIntSet)blackListed, arg_0);
        }
        return property -> true;
    }

    private static /* synthetic */ boolean lambda$getPropertyPermissions$0(MutableIntSet blackListed, int property) {
        return !blackListed.contains(property);
    }
}

