/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public class RoleRecord {
    private final String name;
    private final SortedSet<String> users;

    public RoleRecord(String name, SortedSet<String> users) {
        this.name = name;
        this.users = users;
    }

    public RoleRecord(String name, String ... users) {
        this.name = name;
        this.users = new TreeSet<String>();
        this.users.addAll(Arrays.asList(users));
    }

    public String name() {
        return this.name;
    }

    public SortedSet<String> users() {
        return this.users;
    }

    public Builder augment() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleRecord role = (RoleRecord)o;
        if (this.name != null ? !this.name.equals(role.name) : role.name != null) {
            return false;
        }
        return this.users != null ? this.users.equals(role.users) : role.users == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", users='" + this.users + '\'' + '}';
    }

    public static class Builder {
        private String name;
        private SortedSet<String> users = new TreeSet<String>();

        public Builder() {
        }

        public Builder(RoleRecord base) {
            this.name = base.name;
            this.users = new TreeSet<String>(base.users);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUsers(SortedSet<String> users) {
            this.users = users;
            return this;
        }

        public Builder withUser(String user) {
            this.users.add(user);
            return this;
        }

        public Builder withoutUser(String user) {
            this.users.remove(user);
            return this;
        }

        public RoleRecord build() {
            return new RoleRecord(this.name, this.users);
        }
    }
}

