/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationToken;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public class ShiroAuthToken
implements AuthenticationToken {
    private static final String VALUE_DELIMITER = "'";
    private static final String PAIR_DELIMITER = ", ";
    private static final String KEY_VALUE_DELIMITER = "=";
    private final Map<String, Object> authToken;

    public ShiroAuthToken(Map<String, Object> authToken) {
        this.authToken = authToken;
    }

    public Object getPrincipal() {
        return this.authToken.get("principal");
    }

    public Object getCredentials() {
        return this.authToken.get("credentials");
    }

    public String getScheme() throws InvalidAuthTokenException {
        return AuthToken.safeCast((String)"scheme", this.authToken);
    }

    public String getSchemeSilently() {
        Object scheme = this.authToken.get("scheme");
        return scheme == null ? null : scheme.toString();
    }

    public Map<String, Object> getAuthTokenMap() {
        return this.authToken;
    }

    public boolean supportsRealm(String realm) {
        Object providedRealm = this.authToken.get("realm");
        return providedRealm == null || providedRealm.equals("*") || providedRealm.equals(realm) || providedRealm.toString().isEmpty();
    }

    public String toString() {
        if (this.authToken.isEmpty()) {
            return "{}";
        }
        ArrayList<String> keys = new ArrayList<String>(this.authToken.keySet());
        int schemeIndex = keys.indexOf("scheme");
        if (schemeIndex > 0) {
            keys.set(schemeIndex, (String)keys.get(0));
            keys.set(0, "scheme");
        }
        return keys.stream().map(this::keyValueString).collect(Collectors.joining(PAIR_DELIMITER, "{ ", " }"));
    }

    private String keyValueString(String key) {
        String valueString = key.equals("credentials") ? "******" : String.valueOf(this.authToken.get(key));
        return key + KEY_VALUE_DELIMITER + VALUE_DELIMITER + valueString + VALUE_DELIMITER;
    }
}

