/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.server.security.enterprise.auth.AuthProceduresBase;
import org.neo4j.string.UTF8;

public class UserManagementProcedures
extends AuthProceduresBase {
    @Admin
    @Description(value="Create a new user.")
    @Procedure(name="dbms.security.createUser", mode=Mode.DBMS)
    public void createUser(@Name(value="username") String username, @Name(value="password") String password, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws InvalidArgumentsException, IOException {
        this.userManager.newUser(username, password != null ? UTF8.encode((String)password) : null, requirePasswordChange);
    }

    @Deprecated
    @Description(value="Change the current user's password. Deprecated by dbms.security.changePassword.")
    @Procedure(name="dbms.changePassword", mode=Mode.DBMS, deprecatedBy="dbms.security.changePassword")
    public void changePasswordDeprecated(@Name(value="password") String password) throws InvalidArgumentsException, IOException {
        this.changePassword(password, false);
    }

    @Description(value="Change the current user's password.")
    @Procedure(name="dbms.security.changePassword", mode=Mode.DBMS)
    public void changePassword(@Name(value="password") String password, @Name(value="requirePasswordChange", defaultValue="false") boolean requirePasswordChange) throws InvalidArgumentsException, IOException {
        this.setUserPassword(this.securityContext.subject().username(), password, requirePasswordChange);
    }

    @Description(value="Change the given user's password.")
    @Procedure(name="dbms.security.changeUserPassword", mode=Mode.DBMS)
    public void changeUserPassword(@Name(value="username") String username, @Name(value="newPassword") String newPassword, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws InvalidArgumentsException, IOException {
        this.securityContext.assertCredentialsNotExpired();
        this.setUserPassword(username, newPassword, requirePasswordChange);
    }

    @Admin
    @Description(value="Assign a role to the user.")
    @Procedure(name="dbms.security.addRoleToUser", mode=Mode.DBMS)
    public void addRoleToUser(@Name(value="roleName") String roleName, @Name(value="username") String username) throws IOException, InvalidArgumentsException {
        this.userManager.addRoleToUser(roleName, username);
    }

    @Admin
    @Description(value="Unassign a role from the user.")
    @Procedure(name="dbms.security.removeRoleFromUser", mode=Mode.DBMS)
    public void removeRoleFromUser(@Name(value="roleName") String roleName, @Name(value="username") String username) throws InvalidArgumentsException, IOException {
        this.userManager.removeRoleFromUser(roleName, username);
    }

    @Admin
    @Description(value="Delete the specified user.")
    @Procedure(name="dbms.security.deleteUser", mode=Mode.DBMS)
    public void deleteUser(@Name(value="username") String username) throws InvalidArgumentsException, IOException {
        if (this.userManager.deleteUser(username)) {
            this.kickoutUser(username, "deletion");
        }
    }

    @Admin
    @Description(value="Suspend the specified user.")
    @Procedure(name="dbms.security.suspendUser", mode=Mode.DBMS)
    public void suspendUser(@Name(value="username") String username) throws IOException, InvalidArgumentsException {
        this.userManager.suspendUser(username);
        this.kickoutUser(username, "suspension");
    }

    @Admin
    @Description(value="Activate a suspended user.")
    @Procedure(name="dbms.security.activateUser", mode=Mode.DBMS)
    public void activateUser(@Name(value="username") String username, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        this.userManager.activateUser(username, requirePasswordChange);
    }

    @Admin
    @Description(value="List all local users.")
    @Procedure(name="dbms.security.listUsers", mode=Mode.DBMS)
    public Stream<AuthProceduresBase.UserResult> listUsers() {
        Set users = this.userManager.getAllUsernames();
        if (users.isEmpty()) {
            return Stream.of(this.userResultForSubject());
        }
        return users.stream().map(this::userResultForName);
    }

    @Admin
    @Description(value="List all available roles.")
    @Procedure(name="dbms.security.listRoles", mode=Mode.DBMS)
    public Stream<AuthProceduresBase.RoleResult> listRoles() {
        Set<String> roles = this.userManager.getAllRoleNames();
        return roles.stream().map(this::roleResultForName);
    }

    @Description(value="List all roles assigned to the specified user.")
    @Procedure(name="dbms.security.listRolesForUser", mode=Mode.DBMS)
    public Stream<AuthProceduresBase.StringResult> listRolesForUser(@Name(value="username") String username) throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        return this.userManager.getRoleNamesForUser(username).stream().map(AuthProceduresBase.StringResult::new);
    }

    @Admin
    @Description(value="List all users currently assigned the specified role.")
    @Procedure(name="dbms.security.listUsersForRole", mode=Mode.DBMS)
    public Stream<AuthProceduresBase.StringResult> listUsersForRole(@Name(value="roleName") String roleName) throws InvalidArgumentsException {
        return this.userManager.getUsernamesForRole(roleName).stream().map(AuthProceduresBase.StringResult::new);
    }

    @Admin
    @Description(value="Create a new role.")
    @Procedure(name="dbms.security.createRole", mode=Mode.DBMS)
    public void createRole(@Name(value="roleName") String roleName) throws InvalidArgumentsException, IOException {
        this.userManager.newRole(roleName, new String[0]);
    }

    @Admin
    @Description(value="Delete the specified role. Any role assignments will be removed.")
    @Procedure(name="dbms.security.deleteRole", mode=Mode.DBMS)
    public void deleteRole(@Name(value="roleName") String roleName) throws InvalidArgumentsException, IOException {
        this.userManager.deleteRole(roleName);
    }

    private void setUserPassword(String username, String newPassword, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        this.userManager.setUserPassword(username, newPassword != null ? UTF8.encode((String)newPassword) : null, requirePasswordChange);
        if (this.securityContext.subject().hasUsername(username)) {
            this.securityContext.subject().setPasswordChangeNoLongerRequired();
        }
    }
}

