/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.shiro.authc.AuthenticationToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;

public class PluginShiroAuthToken
extends ShiroAuthToken {
    private final char[] credentials;

    private PluginShiroAuthToken(Map<String, Object> authTokenMap) {
        super(authTokenMap);
        byte[] credentialsBytes = (byte[])super.getCredentials();
        this.credentials = credentialsBytes != null ? StandardCharsets.UTF_8.decode(ByteBuffer.wrap(credentialsBytes)).array() : null;
    }

    @Override
    public Object getCredentials() {
        return this.credentials;
    }

    void clearCredentials() {
        if (this.credentials != null) {
            Arrays.fill(this.credentials, '\u0000');
        }
    }

    public static PluginShiroAuthToken of(ShiroAuthToken shiroAuthToken) {
        return new PluginShiroAuthToken(shiroAuthToken.getAuthTokenMap());
    }

    public static PluginShiroAuthToken of(AuthenticationToken authenticationToken) {
        ShiroAuthToken shiroAuthToken = (ShiroAuthToken)authenticationToken;
        return PluginShiroAuthToken.of(shiroAuthToken);
    }
}

