/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.BasicAuthManager;

public class BasicSecurityContext
implements SecurityContext {
    private final BasicAuthManager authManager;
    private final BasicAuthSubject authSubject;
    private AccessMode accessMode;

    public BasicSecurityContext(BasicAuthManager authManager, User user, AuthenticationResult authenticationResult) {
        this.authManager = authManager;
        this.authSubject = new BasicAuthSubject(user, authenticationResult);
        switch (authenticationResult) {
            case SUCCESS: {
                this.accessMode = AccessMode.Static.FULL;
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                this.accessMode = AccessMode.Static.CREDENTIALS_EXPIRED;
                break;
            }
            default: {
                this.accessMode = AccessMode.Static.NONE;
            }
        }
    }

    public AuthSubject subject() {
        return this.authSubject;
    }

    public boolean isAdmin() {
        return true;
    }

    public SecurityContext freeze() {
        return this;
    }

    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext.Frozen((AuthSubject)this.authSubject, mode);
    }

    public AccessMode mode() {
        return this.accessMode;
    }

    public String toString() {
        return String.format("BasicSecurityContext{ securityContext=%s, accessMode=%s }", this.authSubject.username(), this.accessMode);
    }

    private class BasicAuthSubject
    implements AuthSubject {
        private User user;
        private AuthenticationResult authenticationResult;

        BasicAuthSubject(User user, AuthenticationResult authenticationResult) {
            this.user = user;
            this.authenticationResult = authenticationResult;
        }

        public void logout() {
            this.user = null;
            this.authenticationResult = AuthenticationResult.FAILURE;
        }

        public AuthenticationResult getAuthenticationResult() {
            return this.authenticationResult;
        }

        public void setPasswordChangeNoLongerRequired() {
            if (this.authenticationResult == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
                this.authenticationResult = AuthenticationResult.SUCCESS;
                BasicSecurityContext.this.accessMode = (AccessMode)AccessMode.Static.FULL;
            }
        }

        public String username() {
            return this.user.name();
        }

        public boolean hasUsername(String username) {
            return this.username().equals(username);
        }
    }
}

