/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.nio.file.Path;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="set-default-admin", description={"Sets the default admin user.%nThis user will be granted the admin role on startup if the system has no roles."})
public class SetDefaultAdminCommand
extends AbstractCommand {
    public static final String ADMIN_INI = "admin.ini";
    @CommandLine.Parameters
    private String username;

    public SetDefaultAdminCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Config config = this.loadNeo4jConfig();
        try {
            Path adminIniFile = CommunitySecurityModule.getUserRepositoryFile(config).getParent().resolve(ADMIN_INI);
            if (this.ctx.fs().fileExists(adminIniFile)) {
                this.ctx.fs().deleteFile(adminIniFile);
            }
            FileUserRepository admins = new FileUserRepository(this.ctx.fs(), adminIniFile, (LogProvider)NullLogProvider.getInstance());
            admins.init();
            admins.start();
            admins.create(new User.Builder(this.username, (Credential)LegacyCredential.INACCESSIBLE).build());
            admins.stop();
            admins.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ctx.out().println("default admin user set to '" + this.username + "'");
    }

    @VisibleForTesting
    Config loadNeo4jConfig() {
        Config cfg = Config.newBuilder().fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).commandExpansion(this.allowCommandExpansion).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }
}

