/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Objects;
import java.util.Optional;

public class Neo4jPrincipal {
    public static final String NO_ID = "NO_ID";
    private final String username;
    private final Optional<String> id;

    public Neo4jPrincipal(String username, String id) {
        this.username = username;
        this.id = Optional.ofNullable(id);
    }

    public Neo4jPrincipal(String username) {
        this.username = username;
        this.id = Optional.empty();
    }

    public String getUsername() {
        return this.username;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Neo4jPrincipal that = (Neo4jPrincipal)other;
        return Objects.equals(this.username, that.username) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.id);
    }

    public String toString() {
        return this.username;
    }
}

