/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;

public class StandardConfiguration
implements SpaceFillingCurveConfiguration {
    public static final int DEFAULT_EXTRA_LEVELS = 1;
    protected int extraLevels;

    public StandardConfiguration() {
        this(1);
    }

    public StandardConfiguration(int extraLevels) {
        this.extraLevels = extraLevels;
    }

    @Override
    public boolean stopAtThisDepth(double overlap, int depth, int maxDepth) {
        return overlap >= 0.99 || depth >= maxDepth;
    }

    @Override
    public int maxDepth(Envelope referenceEnvelope, Envelope range, int nbrDim, int maxLevel) {
        Envelope paddedEnvelope = referenceEnvelope.withSideRatioNotTooSmall();
        double searchRatio = range.getArea() / paddedEnvelope.getArea();
        if (Double.isInfinite(searchRatio)) {
            return maxLevel;
        }
        return Math.min(maxLevel, (int)(Math.log(searchRatio) / Math.log(Math.pow(2.0, nbrDim))) + this.extraLevels);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.extraLevels + ")";
    }

    @Override
    public int initialRangesListCapacity() {
        return 1000;
    }
}

